
#ifndef __umove_hpp__
#define __umove_hpp__
#include <ubit/ubox.hpp>

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

class UFloatingbox : public UBox {
  uptr<class UPos> ppos;

public:
  UFloatingbox(const UArgs& = UArgs::none);
  UFloatingbox(u_pos x, u_pos y, const UArgs& = UArgs::none);
  UFloatingbox(class UPos& pos, const UArgs& = UArgs::none);
  
  friend UFloatingbox& ufloatingbox(const UArgs& a = UArgs::none);
  friend UFloatingbox& ufloatingbox(u_pos x, u_pos y, const UArgs& a = UArgs::none);
  
  virtual void move(u_pos x, u_pos y);
  virtual void move(const class UPos& pos);
  virtual void setX(u_pos x);
  virtual void setY(u_pos y);
  ///< changes box location relatively to its parent(s)
  
  virtual void where(u_pos &x, u_pos &y) const;
  virtual u_pos getX() const;
  virtual u_pos getY() const;
  ///< gets box location relatively to its parent(s)
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */

