/* ==================================================== ======== ======= *
 *
 *  uviewImpl.hh [internal implementation: do not use]
 *  Ubit Project  [Elc][beta1][2001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uviewImpl.hh	ubit:b1.11.6"
#ifndef _uviewImpl_hh
#define	_uviewImpl_hh

#include <uborder.hh>

//NOTE: this header is *entirely* implementation dependent ================


struct UMultiList {
public:
  static const int MAXCOUNT = 2;
protected:
  ULink *list_tab[MAXCOUNT];
  int count;
  u_bool is_softwin_list;
public:
  // parses the child list of grp, finds the 1st visible Elem (Item or Group)
  // and adds it (and its followers) as a sublist
  // also checks HARDWIN and SOFTWIN_LIST
  UMultiList(class UContext& curp, UGroup* grp);

  //EX: UMultiList() {
  // for (count = 0; count < MAXCOUNT; count++) list_tab[count] = null;
  //   count = 0;
  //}

  u_bool isSoftwinList() {return is_softwin_list;}

  // adds an Elem (and its followers) as a sublist of the MultiList
  void addList(ULink *l);
  void addSoftwinList(UGroup *grp);

  //!!doit imperativement etre appele en premier!!
  ULink* first() {return list_tab[count = 0];}

  ULink* next(ULink *ch) {
    if (ch->next()) return ch->next();
    else if (++count < MAXCOUNT) return list_tab[count];
    else return null;
  }
};

// ==================================================== [Elc:01] ======= //
// ==================================================== ======== ======= //
// View extensions: used by certain views when useful

class UViewExt {
public:
  // used by viewMove and viewResize callbacks
  // for checking if pos or size has changed
  URegion *old_region;
  //more to come...

  UViewExt();
  ~UViewExt();
};

// ==================================================== [Elc:01] ======= //
// ==================================================== ======== ======= //

struct UViewLayout {
public:
  enum {EXPAND=0, GET_HINTS, IMPOSE_WSIZE} strategy;
  u_dim spec_w, spec_h, cmin_w, cmax_w, cmin_h, cmax_h, line_h, line_w;
  //obs: u_bool keepSize;
  UViewLayout() {strategy = EXPAND; /*keepSize=false;*/}
};

/* ==================================================== ======== ======= */

struct ULayoutData {
  UView *view;
  int    visibleElemCount; //Ubox or Uitem (not Ugroup, not floating)
  u_bool mustLayoutAgain;

  ULayoutData(UView *v) {
    view = v;
    visibleElemCount = 0;
    mustLayoutAgain = false;
  }
};

// ==================================================== [Elc:01] ======= //
// ==================================================== ======== ======= //

struct UViewUpdate {
  // !BEWARE: order is MEANINGFUL: all ITEM operations must be > ITEM_OPS
  enum Mode {
    PAINT_ALL,       // Paint all objects in clipping area
    PAINT_DAMAGED,   // Just paint damaged objects and their children,
    //MAIS AUSSI toutes les vues soeurs qui suivent (a cause des vues 
    //evntuellement superposees, voir note dans UUpdateData ci-dessous)
    //PAINT_CHANGED,   // Just paint objects whose size or pos has changed
    UPDATE_DATA,     // Just update data, do not paint
    LOCATE_ITEM_POS, // Locate an Item from its pos - do NOT paint it
    LOCATE_ITEM_PTR  // Locate an Item from a link or a pointer
  } mode;
  UEvent *e;
  class UItemData *itemData;  // optional, used when searching items
  int overlapp;

  UViewUpdate(Mode _mode) {
    mode = _mode;
    e = null; 
    itemData = null;
    overlapp = 0;
  }
  void setMode(Mode _mode) {mode = _mode;}
  Mode getMode() {return mode;}
};

/* ==================================================== ======== ======= */

struct UUpdateImpl {
  UView *view;
  UMargin margin;
  URegion chr, chclip;
  int flex_space;
  u_bool can_paint;
  UViewUpdate& upmode;

  UUpdateImpl(UView*, const URegion &r, UViewUpdate&);
  virtual ~UUpdateImpl();

  virtual void setFloating(UContext& curp, UGroup* grp, URegion& r);
  virtual void backgroundAndBorder(class UWinGraph&,
				   class UContext &curp, const URegion &r);
  virtual void callbacks(UGroup*, UView* winview);
};

struct UViewUpdateImpl : public UUpdateImpl {
  unsigned char orient;
  unsigned short flexCount;

  UViewUpdateImpl(UView *v, const URegion &r, UViewUpdate &vup, 
		  unsigned short flex_count) : UUpdateImpl(v, r, vup) {
    flexCount = flex_count;
  }
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:01] ======= */

