/* ==================================================== ======== ======= *
 *
 *  uutimer.cc
 *  Ubit Project [Elc::2000]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2000 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:00] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uutimer.cc	ubit2000.11.0"
#include <ubrick.hh>
#include <uevent.hh>
#include <uappli.hh>
#include <utimer.hh>
#include <ugraph.hh>
#include <unat.hh>


const UClass UTimeLapse::uclass("UTimeLapse");


UTimeLapse::UTimeLapse(UTimer *t, int lno) : UCond() {
  timer = t;
  //obs:on = false;
  lapse_no = lno;
  ///###  target = null;
}

u_bool UTimeLapse::match(const UOn*) {
  if (!timer) return false;
  else if (timer->currentLapse() == lapse_no) return true;
  else return false;
}

#if COBS
int UTimeLapse::fire(UTimer *t, u_boolean onoff) {
  //fprintf(stderr, "UWhen::invoke: this=%d\n", this);
  //obs: on = onoff;
  if (target) {
    //UCall *call;
    //if ((call = target->callCast())) 
    //call->invoke(boxlink, e);
    //    else 
    target->update();
  }
  return true; //status;
}
#endif

/* ==================================================== [Elc:99] ======= */
/* ==================================================== ======== ======= */


const UClass UTimer::uclass("UTimer");

UTimer::UTimer(int* lapsedurations, int lapsecount, int cyclecount) {
  appli = null;
  utc = null;
  current_lapse = -1;		// !!!
  lapse_count = lapsecount;

  lapse_durations = new int[lapsecount];
  for (int k = 0; k < lapsecount; k++) 
    lapse_durations[k] = lapsedurations[k];

  cycle_count = cyclecount;
  current_cycle = 0;
  running = false;
}

/* ==================================================== [Elc:99] ======= */
/* ==================================================== ======== ======= */

// The timer must be realized before being used
u_bool UTimer::realize(class UAppli *ac) {
  if (utc) {
    uerror("UTimer::realize", "Timer is already realized");
    return true;
  }
  else { 
    appli = ac;
    utc = new UNatTimer(ac->getNatAppli(), this);  // native implementation
    return (utc != null);
  }
}


//EX: UTimeLapse& UTimer::lapse(int lapse_no) {
/*
UTimeLapse& UTimer::when(int lapse_no) {
  if (lapse_no >= lapse_count)
    uerror("UTimer::lapse", "No so many lapses [max = %d Time Lapses]", 
	  lapse_count);

  ///###UTimeLapse *l = new UTimeLapse(this, lapse_no);
   ///#### ULink *link = new ULink(l);
   ///#### lapses.add(link);
   ///#### return *l;
}
*/

void UTimer::start() {
  if (utc) {
    step();
    running = utc->run(lapse_durations[current_lapse]);
  }
  else running = false; 
}

void UTimer::restart() {
  current_lapse = 0;
  current_cycle = 0;
  start();
}

void UTimer::stop() {
  if (utc) utc->stop();
  running = false;
}


// returns -1 when there is nothing more to do
//

int UTimer::step() {
  //fprintf(stderr, "UTimer::step(rep=%d, int=%d)\n", 
  //current_cycle, current_lapse);

  for (ULink *lk = lapses.first(); lk != null; lk = lk->next()) {
    UTimeLapse *lapse = (UTimeLapse*)lk->brick();

    ///####  if (lapse->lapse_no == current_lapse)
      ///####  lapse->call(null);
#if COBS    
    if (lapse->lapse_no == current_lapse && !lapse->on)
      lapse->fire(this, true);	// passer a l'etat ON
    else if (lapse->lapse_no != current_lapse && lapse->on)
      lapse->fire(this, false);	// passer a l'etat OFF
#endif
  }

  //appli->flush();		// tres important !

  current_lapse++;
  if (current_lapse < lapse_count) 
    // continuer apres attente donnee par intervals[currentInterval]
    return lapse_durations[current_lapse];

  // 
  current_cycle++;
  if (cycle_count < 0	// repeter indefiniment si cycle_count < 0
      || current_cycle < cycle_count) {
    current_lapse = 0;
    return lapse_durations[0];
  }

  // sinon c'est fini !
  return -1;
}


/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:99] ======= */
