/* ==================================================== ======== ======= *
 *
 *  uselect.hh
 *  Ubit Project [Elc][beta1][2001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

#ifndef _uselect_hh
#define	_uselect_hh

//pragma ident	"@(#)uselect.hh	ubit:b1.11.O"

// NOTES ON SYNTAX:
//
//   // the radio selector is given as a child of the objects it selects
//   URadioSelect& sel = uradioSelect();
//   ...
//   ubox( ubutton("One" + sel) + ucheckbox("Two" + sel) + utext("Three" + sel) + ...)
//   sel.set(2);
//   ucheckbox("Four" + sel)
//   ubutton("Five).add(sel)


class URadioSelect : public UProp {
protected:
  int index, card;
  void selectCB(UEvent *e);
  class UCall *select_call, *unselect_call;
public:
  static  const UClass  uclass;
  virtual const UClass* getClass() const {return &uclass;}

  // Notes: 
  // -- the selector must be a child of all parents it selects
  // -- index 0 corresponds to the first parent. 
  // -- nothing selected by default (ie. index = -1)
  URadioSelect(int index = -1, u_modes = 0);
  virtual ~URadioSelect() {clean();}

  // returns the selected parent (null if nothing selected)
  UGroup* getSelected();

  // returns the index of the selected parent (-1 if nothing selected)
  // -- index 0 corresponds to the first parent
  int getIndex();

  // selects this object (which must be a parent of the selector)
  void setSelected(UGroup* object);
  void set(UGroup* object);

  // selects the Nth parent of the selector 
  // -- index == 0  corresponds to the first parent
  // -- index == -1 unselects all parents
  void setIndex(int index);
  void set(int index);

  // update display (it may be necessay to call this function when adding
  // or removing parents)
  virtual void update();

  // calls UOn::change then UOn::action callbacks when selection is changed
  virtual void changed(u_bool update_now);

 //==== Ubit Intrinsics

  virtual void putProp(UContext*, class UCtrl*);
  virtual void addingTo(ULink *selflink, UGroup *parent);
  //NB: removingFrom() requires a destructor to be defined
  virtual void removingFrom(ULink *selflink, UGroup *parent);
};

URadioSelect& uradioSelect(int index = -1);

#endif

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:00] ======= */
