/* ==================================================== ======== ======= *
 *
 *  upix.hh
 *  Ubit Project  [Elc][beta1][2001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (Subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

#ifndef _upix_hh
#define	_upix_hh
//pragma ident	"@(#)upix.hh	ubit:b1.6.1"

// Shortcuts (see notes below)

UIma& uima(const UStr &filename);
UIma& uima(const UStr *filename);
UIma& uima(const char *filename);
//!WARNING: 'xpm_data' is NOT copied internally and must not be freed!
UIma& uima(const char **xpm_data);

UPix& upix(const UStr &filename);
UPix& upix(const UStr *filename);
UPix& upix(const char *filename);
//!WARNING: 'xpm_data' is NOT copied internally and must not be freed!
UPix& upix(const char **xpm_data);

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

class UIma: public UItem {
  friend class UBox;
  friend class UNatIma;
  friend class UPix;
public:
  static  const UClass  uclass;
  virtual const UClass* getClass() const {return &uclass;}

  enum ImaStat {
    NoMoreMemory  = -6,
    CantOpenFile  = -5,
    CantReadFile  = -4,
    InvalidData   = -3,
    InvalidFile   = -2,
    InvalidFormat = -1,
    NotLoaded     =  0,  
    Loaded        =  1  
    //ColorError =  2
  };

  //NOTES: 
  // -- supported formats depend on which packages where linked to the Ubit lib
  //    (XPM and GIF formats are supported by default)
  // -- a pathname prefix is implicitely added if 'filename' does NOT start
  //    with / or . Besides, path variables starting by $ can be specified
  //    (see UAppli.setImaPath() for details)
  // -- UIma does not support background transparency in the current
  //    version but subclass UPix does with XPM images

  //Note: by default, image files are loaded when images are displayed
  UIma(const UStr& filename, u_modes = 0);
  UIma(const UStr* filename, u_modes = 0);
  UIma(const char* filename = null, u_modes = 0);
  UIma(const char **xpm_data, u_modes = 0);
  virtual ~UIma();

  // if last arg. is false:
  // -- this mehod sets the filename that will be used for loading the image
  //    when it is displayed
  // if last arg. is true:
  // -- this mehod also calls 'realize' (see below) if the image is displayed 
  //    (ie. if it has visible parents)
  void set(const UStr& filename, u_bool realize = true);
  void set(const UStr* filename, u_bool realize = true);
  void set(const char *filename, u_bool realize = true);

  // same as before but specifies compiled XPM data instead of a file name
  //!!WARNING: 'xpm_data' is NOT copied internally and must not be freed
  void set(const char **xpm_data, u_bool realize = true);

  // this function loads and realizes the image
  // Notes:
  // -- this function is automatically called when needed by the Ubit lib
  // -- you can call it explicitely if you want to load image files in advance
  //    and check if images could actually be loaded (as it returns the 
  //    loading status)
  // -- the UDisp arg. can be the UAppli pointer
  // -- arg. force_reload forces the image to be loaded again in case the image
  //    has already be loaded before
  int realize(class UDisp *disp, u_bool force_reload = true) const;

  // this function returns the loading status (see enum ImaStat)
  int getStatus();

  // returns true if the image has actually been loaded and realized
  u_bool isRealized() const;

  // returns true if the image background is shaped (= so called "transparent")
  u_bool isShaped() const;
  u_bool isTransparent() const {return isShaped();}

  // returns the image size
  // !NOTE: the size is unknown if the image has not yet been realized
  u_dim getHeight() const;
  u_dim getWidth()  const;

  // returns the image name (if any, null otherwise)
  //const char* getName() const {return name;}

  // update parents' views
  virtual void update(); 

  //==== Ubit Intrinsics ===

  // provides accces to the implementation specific native image
  class UNatIma* getNatIma() const {return natimas;}
  virtual void cleanCache();
  virtual void getSize(UContext*, u_dim *w, u_dim *h) const;
  virtual void paint(UWinGraph&, UContext*, const URegion &r) const;

protected:
  mutable class UNatIma *natimas;
  char *name;
  const char **data;
  const UBgcolor *bgcolor;
  mutable signed char load_stat;  // can have negative values
  mutable u_bool read_from_file, read_from_data;

  static class UNatIma* findImaInCache(class UNatDisp*, class UNatIma *natimas,
				       int lscale, int &fsize);
  static class UNatIma* addImaInCache(class UNatDisp*, class UNatIma *natimas,
				      int lscale, int fsize);
};

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

class UPix: public UIma {
  friend class UBox;
  friend class UNatPix;
protected:
  mutable class UNatPix *natpix;
public:
  static  const UClass  uclass;
  virtual const UClass* getClass() const {return &uclass;}

  // Predefined Pixmaps
  // !NOTE: these icons were originally designed by Ludvig A. Norin for
  // !the FVWM window manager. Please refer to file uufvwmpix.cc for details.

  // Rectangular Pixmaps with a white background
  static UPix Wfolder, Wofolder, Wdoc;

  // Shaped Pixmaps (ie. with a "transparent" background)
  // (Note that shaped pixmaps take slightly more time to display)
  static UPix 
    folder, ofolder, doc, rball, diskette, cross,
    manual, edit, clock, stop, ray, question, bricks, colors, 
    term, mail, windows, eyes, camera, bomb, left, right, raise, lower;

  //Notes: 
  // -- by default, image files are loaded when images are displayed
  // -- UPix supports background "transparency" (= shapes) with XPM images
  UPix(const UStr& filename, u_modes = 0);
  UPix(const UStr* filename, u_modes = 0);
  UPix(const char* filename = null, u_modes = 0);
  // !!WARNING: 'xpm_data' is NOT copied internally and must not be freed
  UPix(const char **xpm_data, u_modes = 0);
  UPix(const char **xpm_data, const UBgcolor&, u_modes = 0);
  virtual ~UPix();

  //==== Ubit Intrinsics ===

  class UNatPix* getNatPix() const {return natpix;}
  virtual void cleanCache();
  virtual void getSize(UContext*, u_dim *w, u_dim *h) const;
  virtual void paint(UWinGraph&, UContext*, const URegion &r) const;
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:01] ======= */
