/* ==================================================== ======== ======= *
 *
 *  ubrickImpl.hh [internal implementation: do not use]
 *  Ubit Project [Elc][beta1][2001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

#ifndef _ubrickImpl_hh
#define	_ubrickImpl_hh
//pragma ident	"@(#)ubrickImpl.hh	ubit:b1.11.6"

//package_private: ====[internal implementation]===========================
//NOTE: this header is reserved to the Ubit intrinsics

class UGenLink {
public:
  UGenLink *nextlink;

  UGenLink() {nextlink = null;}
  UGenLink* next() {return nextlink;}  // NB: NOT virtual!
};

/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */

class ULink : public UGenLink {
  friend class UChain;
  friend class UArgs;
public:
  UBrick *b;
  UGroup *par;
  const UCond *cond;

  ULink(UBrick *brick) : UGenLink() {
    b = brick; par = null; cond = null;
  }
  //NOTE importante: ~ULink ne detache PAS les liens !
  virtual ~ULink() {}  //necessaire

  const UCond* getCond() {return cond;}
  void setCond(const UCond &c) {cond = &c;}

  u_bool verifies(const UContext *ctx, const class UCtrl *ctrl) const;

  u_bool match(const UCond &_cond) const {
    //NB: null cond means do nothing
    return (cond != null && cond == &_cond);  //a etendre pour UOn copies!!!
  }

  // returns next Link (NB: NOT virtual!)
  ULink* next()	const {return (ULink*)nextlink;}

  // returns parent
  UGroup* parent() const {return par;}

  // returns Child
  UBrick* brick() const {return b;}

  //internals
  void setParent(UGroup* parent) {par = parent;}
  void setBrick(UBrick* brick) {b = brick;}
  // OBS: 
  virtual class UFloating* floatingCast()  {return null;}
};

/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */

class ULinkLink : public UGenLink {
  friend class ULLChain;
protected:
  ULink *lk;
public:
  ULinkLink(ULink *l) : UGenLink() {lk = l;}

  // returns next Link
  ULinkLink* next() {return (ULinkLink*)nextlink;} // NB: NOT virtual!

  // returns Parent
  UGroup* parent() {return lk->parent();}

  // returns Child Link. 
  ULink* link() {return lk;}
};

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

class UGenChain {
protected:
  UGenLink *firstlink, *lastlink;
public:
  UGenChain() {firstlink = null, lastlink = null;};

  // adds link at the end of the chain
  void add(UGenLink *link);
 
  // removes and returns link (null if not found)
  void remove(UGenLink *link);

  // merge 'this' chain with the chain given as an argument
  void append(UGenChain*);

  // inserts 'link' after 'poslink' in the chain
  // special case:
  // -- if 'poslink=null' => add 'link' at the BEGINNING of the list
  void insertAfter(UGenLink *link, UGenLink *poslink);

  // removes and returns the link that FOLLOWS 'poslink'
  // (but does not remove 'poslink' itself!)
  // -- returns null and do nothing if no link follows 'poslink'
  // special case:
  // -- if 'poslink=null' => removes and returns the FIRST link in the list
  UGenLink* removeAfter(UGenLink *poslink);

  // resets the Chain so that it points to null
  // -- returns the first link that was previously pointed by the Chain
  // -- this fct. does not destroy the links and does not free anything
  UGenLink *reset();
};

/* ==================================================== ======== ======= */

class UChain : public UGenChain {
public:
  ULink *first() const {return (ULink*)firstlink;}
  ULink *last()  const {return (ULink*)lastlink;}

  ULink* removeAfter(ULink *poslink) {
    return (ULink*)UGenChain::removeAfter(poslink);
  }
  // search first occurence of 'brick' in the list
  // - returns the 'brick' link if found and  null otherwise
  // - searches from 'fromlink' if not null and from the beginning otherwise
  ULink* search(const UBrick *brick, const ULink *fromlink = null);
};

class ULLChain : public UGenChain {
public:
  ULinkLink *first() const {return (ULinkLink*)firstlink;}
  ULinkLink *last()  const {return (ULinkLink*)lastlink;}

  ULinkLink* removeAfter(ULinkLink *poslink) {
    return (ULinkLink*)UGenChain::removeAfter(poslink);
  }
  // removes the first ULinkLink that is pointing to this ULink
  ULinkLink* removePointingTo(ULink *pointed);

  void fireParents(class UEvent&, const UOn&) const;
  void updateParents(const class UUpdate&) const;
  void setModesOfParents(u_modes bmodes, u_modes cmodes, u_bool onoff) const;
  void setModesOfParentViews(int vmodes, u_bool on_off) const;
};

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

class UArgs {
  friend class UGroup;
  friend class UBox;
private:
  UArgs operator=(UArgs);    // a = b;  illegal
public:
  UChain children;

  static const UArgs none;
  UArgs();
  UArgs(const char*);
  UArgs(UBrick*);
  UArgs(UBrick&);
  UArgs(ULink&);
  UArgs(ULink*);
  friend UArgs operator+(UArgs, const char*);
  friend UArgs operator+(UArgs, UBrick*);
  friend UArgs operator+(UArgs, UBrick&);
  friend UArgs operator+(UArgs, ULink&);
  friend UArgs operator+(UArgs, ULink*);
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:01] ======= */
