#!/bin/sh -e

VERSION=$2
XPI=$3
PACKAGE=$(dpkg-parsechangelog | sed -n 's/^Source: //p')
TAR=../${PACKAGE}_${VERSION}.orig.tar.bz2
DIR=${PACKAGE}-${VERSION}

TAR_OPTS="--exclude *.orig \
	--exclude *.rej \
	--exclude *~ \
	--exclude \#*\# \
	--exclude ${DIR}/platform \
	--exclude ${DIR}/modules/parser/tng"

/usr/bin/xpi-unpack $XPI $DIR

echo "The following files will be removed from upstream tarball:"
cd $DIR
find . -name '*.orig' -o \
	-name '*.rej' -o \
	-name '*~' -o \
	-name '\#*\#' -o \
	-path './platform*' -o \
	-path './modules/parser/tng*'
cd ..
GZIP=--best tar -jc $TAR_OPTS -f $TAR $DIR
rm -rf $DIR
rm $XPI

