//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.3.0, Copyright (C) Ashif S. Harji 2000
// 
// uStaticPriorityQ.h -- 
// 
// Author           : Ashif S. Harji
// Created On       : Fri Jan 14 17:59:34 2000
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Oct 10 11:12:50 2005
// Update Count     : 75
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#ifndef __U_STATICPRIORITYQ_H__
#define __U_STATICPRIORITYQ_H__

#pragma __U_NOT_USER_CODE__


//#include <uDebug.h>

#include <uC++.h>
#include <uStaticPIQ.h>

#include <cstring>					// access: ffs


#define __U_MAX_NUMBER_PRIORITIES__ 32


class uStaticPriorityQ : public uBasePrioritySeq {
  protected:
    uBaseTaskSeq uObjects[__U_MAX_NUMBER_PRIORITIES__];
    unsigned int uMask;					// allow access to all queue flags

    int uCurrPriority;
  public:
    uStaticPriorityQ();
    virtual bool empty() const;
    virtual uBaseTaskDL *head() const;
    virtual int add( uBaseTaskDL *node, uBaseTask *uOwner );
    virtual uBaseTaskDL *drop();
    virtual void remove( uBaseTaskDL *node );
    virtual void uOnAcquire(uBaseTask &uOldOwner);
    virtual void uOnRelease( uBaseTask &uOwner );

    int uAfterEntry( uBaseTask *uOwner );
}; // StaticPriorityQ


template<class List, class Node> class uStaticPriorityScheduleQ : public uBaseSchedule<Node> {
  protected:
    List uObjects[__U_MAX_NUMBER_PRIORITIES__];
    unsigned int uMask;					// allow access to all queue flags
    unsigned int verCount;
  public:
    uStaticPriorityScheduleQ() {
	verCount = uMask = 0;
    } // uStaticPriorityScheduleQ::uStaticPriorityScheduleQ

    virtual bool empty() const {
	return uMask == 0;
    } // uStaticPriorityScheduleQ::empty

    virtual Node *head() const {
	int highestPriority = ffs( uMask ) - 1;

	if ( highestPriority >= 0 ) {
	    Node *node = uObjects[highestPriority].head();
	    return node;
	} else {
	    return NULL;
	} // if
    } // uStaticPriorityScheduleQ::head

    virtual void add( Node *node ) {
	int priority = uGetActivePriorityValue( node->uGet() );
#ifdef __U_DEBUG__
	uAssert( 0 <= priority && priority <= __U_MAX_NUMBER_PRIORITIES__ - 1 );
#endif // __U_DEBUG__
	uObjects[priority].add( node );
	uMask |= 1ul << priority;
#ifdef __U_DEBUG_H__
	uDebugPrt( "(uStaticPriorityScheduleQ &)0x%p.add( 0x%p ) task %.256s (0x%p) adding task %.256s (0x%p) with priority %d on cluster 0x%p\n",
		   this, node, uThisTask().getName(), &uThisTask(), node->uGet().getName(), &node->uGet(), priority, &uThisCluster() );
#endif // __U_DEBUG_H__
    } // uStaticPriorityScheduleQ::add

    virtual Node *drop() {
	int highestPriority = ffs( uMask ) - 1;

	if ( highestPriority >= 0 ) {
	    Node *node = uObjects[highestPriority].drop();
	    if ( uObjects[highestPriority].empty() ) {
		uMask &= ~ ( 1ul << highestPriority );
	    } // if
#ifdef __U_DEBUG_H__
	    uDebugPrt( "(uStaticPriorityScheduleQ &)0x%p.drop( 0x%p ) task %.256s (0x%p) removing task %.256s (0x%p) with priority %d on cluster 0x%p\n",
		       this, node, uThisTask().getName(), &uThisTask(), node->uGet().getName(), &node->uGet(), highestPriority, &uThisCluster() );
#endif // __U_DEBUG_H__
	    return node;
	} else {
	    return NULL;
	} // if
    } // uStaticPriorityScheduleQ::drop

    virtual bool uCheckPriority( Node &, Node & ) {
	return false;
    } // uStaticPriorityScheduleQ::uCheckPriority

    virtual void uResetPriority( Node &, Node & ) {
    } // uStaticPriorityScheduleQ::uResetPriority

    virtual void addInitialize( uBaseTaskSeq & ) {
    } // uStaticPriorityScheduleQ::addInitialize

    virtual void removeInitialize( uBaseTaskSeq & ) {
    } // uStaticPriorityScheduleQ::removeInitialize

    virtual void uRescheduleTask( uBaseTaskDL *, uBaseTaskSeq & ) {
    } // uStaticPriorityScheduleQ::uRescheduleTask
}; // uStaticPriorityScheduleQ


template<class List, class Node> class uStaticPriorityScheduleSeq : public uStaticPriorityScheduleQ<List, Node> {
  protected:
    using uStaticPriorityScheduleQ<List, Node>::uObjects;
    using uStaticPriorityScheduleQ<List, Node>::uMask;
    using uStaticPriorityScheduleQ<List, Node>::uSetActivePriority;
  public:
    virtual bool uCheckPriority( Node &owner, Node &calling ) {
	return uGetActivePriorityValue( owner.uGet() ) > uGetActivePriorityValue( calling.uGet() );
    } // uPriorityScheduleSeq::uCheckPriority

    virtual void uResetPriority( Node &owner, Node &calling ) {
	int priority;
	uBaseTask &uOwner = owner.uGet();
	uBaseTask &uCalling = calling.uGet();
	// if same, update owner based on uPIQ
	if ( &uOwner == &uCalling ) {
	    priority = (static_cast<uStaticPIQ *>(uOwner.uPIQ))->uGetHighestPriority(); // TODO: dynamic needed???
	    // if no inheritance priority use base priority
	    if ( priority == -1 ) {
		priority = uOwner.getBasePriority();
	    } // if
	} else {  // otherwise, update to atmost calling task's priority
	    if ( uCalling.getActivePriorityValue() > uOwner.getActivePriorityValue() ) return;
	    priority = uCalling.getActivePriorityValue();
	} // if
		
	if ( owner.listed() ) {
	    remove( &owner );
	    uSetActivePriority( uOwner, priority );
	    add( &owner );
	} else {
	    uSetActivePriority( uOwner, priority );
	} // if
    } // uPriorityScheduleSeq::uResetPriority

    virtual void remove( Node *node ) {
	int priority = uGetActivePriorityValue( node->uGet() );
	uObjects[priority].remove( node );
	if ( uObjects[priority].empty() ) {
	    uMask &= ~ ( 1ul << priority );
	} // if
    } // uPriorityScheduleSeq::remove
}; // uPriorityScheduleSeq


#endif //  __U_STATICPRIORITYQ_H__


// Local Variables: //
// compile-command: "gmake install" //
// End: //
