//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 2003
// 
// StringIO.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Wed Jan 22 12:32:28 2003
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Apr 22 17:10:22 2003
// Update Count     : 3
// 

#include <uC++.h>
#include <uIOStream.h>
#include <uIOManip.h>
#include <uFStream.h>

#include <string>
using std::string;

// Routines needed to do I/O on strings from uC++

uOStream &operator<<( uOStream &outstream, const string s ) {
    uIosWrapper wrapper( outstream );                   // establish mutual exclusion

    outstream.stream() << s;                            // use underlying stream
    return outstream;
}

uIStream &operator>>( uIStream &instream, string &s ) {
    uIosWrapper wrapper( instream );                    // establish mutual exclusion

    instream.stream() >> s;                             // use underlying stream
    return instream;
}

uIStream &getline( uIStream &instream, string &s, char terminator = '\n' ) {
    uIosWrapper wrapper( instream );                    // establish mutual exclusion

    getline( instream.stream(), s, terminator );        // use underlying stream
    return instream;
}

void uMain::main() {
    uIStream    *infile;                                // pointer to input stream
    uOStream    *outfile = &uCout;                      // pointer to output stream; default to cout
    string      str;

    switch ( argc ) {
      case 3:
        try {
            outfile = new uOFStream( argv[2] );         // open the outfile file
        } catch( uFile::uFailure ) {
            uCerr << "Could not open output file \"" << argv[2] << "\"" << endl;
            uExit( -1 );                                // TERMINATE!
        } // try
        // fall through to handle input file
      case 2:
        try {
            infile = new uIFStream( argv[1] );          // open the first input file
        } catch( uFile::uFailure ) {
            uCerr << "Could not open input file \"" << argv[1] << "\"" << endl;
            uExit( -1 );                                // TERMINATE!
        } // try
        break;
      default:                                          // must specify an input file
        uCerr << "Usage: " << argv[0] << " input-file [output-file]" << endl;
        uExit( -1 );                                    // TERMINATE!
    } // swtich

    *infile >> resetiosflags( std::ios::skipws );		// turn off white space skipping during input

    for ( ;; ) {                                        // copy input file to output file
        getline( *infile, str );                        // read a line
      if ( infile->eof() ) break;
        *outfile << str << endl;                        // write a line
    } // for
    delete infile;
    if ( outfile != &uCout ) delete outfile;            // do not delete cout!
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "u++ StringIO.cc" //
// End: //
