#include <string>
#include <warped/WarpedMain.h>
#include <warped/warped.h>
#include "TyvisPluginLoader.hh"
#include "VHDLApplication.hh"

using std::string;

int
main( int argc, char **argv ){
  if( argc < 2 ){
    std::cout << "Usage: tyvis <tyvis module filename>" << std::endl;
    exit( -1 );
  }
  
  const string fileName( argv[1] );
  VHDLApplication *app = TyvisPluginLoader::instance().getVHDLApplication( fileName );
  ASSERT( app != 0 );

  WarpedMain wm( app );
  
  wm.main( argc, argv );
  
  return 0;
}
