//---------------------------------------------------------------------------
// Copyright (c) 1995 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//
// $Id: Wait.cc,v 1.2 2003/12/08 19:24:39 dmartin Exp $
//
//---------------------------------------------------------------------------

#include "Wait.hh"
#include "SignalBase.hh"

bool
defaultWaitCond(VHDLKernel*) {
  return true;
}


PhysicalType
defaultWaitTimeout( VHDLKernel* ) {
  return PhysicalType(ObjectBase::VARIABLE, 
		      UniversalLongLongInteger(VHDLVTime::getVHDLVTimePositiveInfinity().getMajor()), 
		      SavanttimeType_info);
}


Wait&
Wait::operator=(const Wait &rhs) {
  sensList = rhs.sensList;
  cond     = rhs.cond;
  timeout  = rhs.timeout;

  return *this;
}

bool
Wait::sensitiveTo(int sigid) {
  bool retval = false;
  for(unsigned int i = 0; i < getSensSize(); i++ ){
    if( isSensitive(sigid,sensList[i]) ){
      retval = true;
      break;
    }
  }
  return retval;
}

bool
Wait::isSensitive(int sigid, ScalarType* signal) {
  return ( ((SignalBase*)(signal->getObject()))->getSigId() == sigid );
}

void
Wait::destructSensitivityList(){
  for( vector<VHDLType*>::iterator i = sensList.begin();
       i < sensList.begin();
       i++ ){
    delete (*i);
  }
  sensList.clear();
}

void
Wait::addSensitivityTo( VHDLType *toAdd ){
  sensList.push_back( toAdd );
}


bool
Wait::isSensitive(int sigid, ArrayType* signal) {
  bool retval = false;
  int noOfElements = signal->length(0);
  for(int i = 0; i < noOfElements; i++) {
    if( isSensitive(sigid, &(signal->get_element(i)) ) ){
      retval = true;
      break;
    }
  }
  
  return retval; 
}

bool
Wait::isSensitive(int sigid, RecordType* signal) {
  bool retval = false;
  int noOfElements = signal->get_number_of_fields();
  for(int i=1; i <= noOfElements; i++) {
    if( isSensitive(sigid,(VHDLType*)&(signal->get_field(i))) ){
      retval = true;
      break;
    }
  }
  return retval; 
}

bool
Wait::isSensitive(int sigid, VHDLType* signal) {
  bool retval = false;
  switch(signal->get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    retval = isSensitive(sigid,(ScalarType*)signal);
    break;
  case ARRAY_TYPE:
    retval = isSensitive(sigid,(ArrayType *) signal);
    break;
  case RECORD_TYPE:
    retval = isSensitive(sigid,(RecordType*)signal);
    break;
  default:
    cerr << "Unknown type " << signal->get_kind() << ", aborting" << endl;
    abort();
  }
  return retval;
}

void
Wait::print(ostream& os) const {
  if (getSensSize() > 0) {
    os << " signals: ";
    for( unsigned int i = 0; i < getSensSize(); i++ ){
      os << sensList[i] << endl;
      sensList[i]->print(os);
    }
  }
  else {
    os << "(empty senslist)";
  }
}
