#include "ObjectBase.hh"
#include "SourceData.hh"
#include "SourceInfo.hh"
#include "VHDLKernel.hh"

SourceData::SourceData() : SourceBase() {
  sourceProcess = NULL;
  sourceObject          = NULL;
  connected     = true;
}

SourceData::SourceData(VHDLKernel *sourceProcessPtr) : SourceBase() {
  sourceProcess = sourceProcessPtr;
  sourceObject          = NULL;
  connected     = true;
}

VHDLKernel *
SourceData::getSourceId() const {
  return sourceProcess;
}

void 
SourceData::setSourceId(VHDLKernel* srcProcPtr) {
  sourceProcess = srcProcPtr;
}

VHDLType * 
SourceData::getData() const {
  return sourceObject;
}

SourceData *
SourceData::getDriver( int processId ){
  ASSERT( sourceProcess != 0 );
  if( sourceProcess->getVHDLProcessId() == processId ) {
    return this;
  }
  
  return 0;
}

SourceData *
SourceData::getDriver( VHDLKernel* procPtr ){
  if ( sourceProcess == procPtr ){
    return this;
  }
  
  return NULL;
}


SourceData *
SourceData::getDriveratIndex(int) {
  return this;
}

void 
SourceData::setData(VHDLType *newSourceObject) {
  sourceObject = newSourceObject;
}

bool
SourceData::_is_child_present(VHDLKernel *procPtr) {
  return (sourceProcess == procPtr);
}

bool
SourceData::_is_anonymous_driver() {
  if (sourceProcess == SourceBase::ANONYMOUS_PROCESS_ID) {
    return true;
  }

  return false;
}

void 
SourceData::updateData(const VHDLData &newValue ){
  connected = true;
  sourceObject->getObject()->updateVal( newValue );
}

void 
SourceData::updateData(const VHDLType &newSourceObject) {
  connected = true;
  *sourceObject     = newSourceObject;
}

int 
SourceData::addChild(VHDLType *sourceSignal, VHDLKernel *srcProcPtr ){
  sourceObject          = sourceSignal;
  sourceProcess = srcProcPtr;
  
  if ( parent != NULL && 
       sourceProcess != SourceBase::ANONYMOUS_PROCESS_ID ){
    parent->addToRootDriverTable( this );
  }

  return 1;
}

int 
SourceData::addChild(SourceBase*) {
  cerr << "SourceData::addChild(SourceBase*) should never be called!!" << endl;
  abort();
  return 0;
}

void 
SourceData::print(ostream& os) const {
  os << "Source(" << sourceProcess << ") = ";
  sourceObject->print(os);
  os << endl;
}

VHDLType *
SourceData::resolve(VHDLKernel*, SigType) {
  //This is where the difference between a composite resolved signal 
  //resolution and resolution of composite signal of resolved subtype lies
  if(getData()->getObject()->getParentCompositeType() == NULL) {
    return getData();
  }
  else {
    return getData()->getObject()->getParentCompositeType();
  }
}
