#ifndef RVALUE_HH
#define RVALUE_HH

class VHDLData;

class RValue {
public:
  virtual const VHDLData &readVal() const = 0;
  virtual int getIntValue() const = 0;
  virtual LONG getInt64Value() const = 0;
  virtual double getDoubleValue() const = 0;

  virtual bool operator==( const RValue &compareTo ) const = 0;
  virtual bool operator!=( const RValue &compareTo ) const = 0;
  virtual bool operator>( const RValue &compareTo ) const = 0;
  virtual bool operator>=( const RValue &compareTo ) const = 0;
  virtual bool operator<( const RValue &compareTo ) const = 0;
  virtual bool operator<=( const RValue &compareTo ) const = 0;


protected:
  RValue(){}
  virtual ~RValue(){}
};

#endif

