



/*
 *  m4/m4_TTtypes.m4  --  header for libTT objects inheritance
 *                        used as template for a lot of autogenerated files.
 *
 *  Copyright (C) 2001 by Massimiliano Ghilardi
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 */

/* ttobj: The superclass of all objects */
define(`TTdef_ttobj',`field(tobj,id)
    field(void *,userdata)
    field(struct s_tavl,AVLttobjs)
    field(ttlistener,listeners)')
define(`TTFNdef_ttobj',`protected(uldat magicbit,magicbit,$1)
    protected(uldat magic,magic,$1)
    protected(uldat size,size,$1)
    protected($1 (*New)(ttfn_$1 FN),New,$1)
    protected($1 (*Realize)($1 o),Realize,$1)
    protected(void (*Del)($1),Del,$1)
    exported(void (*SetUserData)($1 o, void *data),SetUserData,$1,2,void,$1,void *)
    exported(void *(*GetUserData)($1 o),GetUserData,$1,1,void *,$1)')

/* ttvisible: The superclass of all visible objects */
define(`TTdef_ttvisible',`extends(ttobj,$1)
    field(uldat,vflags)
    field(ttvisible,prev)
    field(ttvisible,next)
    field(ttvisible,parent)
    field(ttvisible,firstchild)
    field(ttvisible,lastchild)
    field(tttheme,theme)')
define(`TTFNdef_ttvisible',`extends(ttobj,$1)
    public(void (*Add)($1 o, ttvisible child),Add,$1,2,void,$1,ttvisible)
    public(void (*AddTo)($1 o, ttvisible parent),AddTo,$1,2,void,$1,ttvisible)
    public(void (*Remove)($1 o),Remove,$1,1,void,$1)
    public(void (*SetVisible)($1 o, byte on_off),SetVisible,$1,2,void,$1,byte)
    public(void (*SetTheme)($1 o, tttheme theme),SetTheme,$1,2,void,$1,tttheme)
    public(void (*Repaint)($1 o, dat width, dat height, dat x, dat y),Repaint,$1,5,void,$1,dat,dat,dat,dat)
    exported(ttvisible (*GetPrev)($1 o),GetPrev,$1,1,ttvisible,$1)
    exported(ttvisible (*GetNext)($1 o),GetNext,$1,1,ttvisible,$1)
    exported(ttvisible (*GetParent)($1 o),GetParent,$1,1,ttvisible,$1)
    exported(ttvisible (*GetFirstChild)($1 o),GetFirstChild,$1,1,ttvisible,$1)
    exported(ttvisible (*GetLastChild)($1 o),GetLastChild,$1,1,ttvisible,$1)
    exported(tttheme (*GetTheme)($1 o),GetTheme,$1,1,tttheme,$1)')


/* ttnative: class representing all server visible objects not created by us */
define(`TTdef_ttnative',`extends(ttvisible,$1)')
define(`TTFNdef_ttnative',`extends(ttvisible,$1)
    exported(ttnative (*GetFirstScreen)(void),GetFirstScreen,$1,0,ttnative)')

/* ttwidget: The superclass of all window-like visible containers */
define(`TTdef_ttwidget',`extends(ttvisible,$1)')
define(`TTFNdef_ttwidget',`extends(ttvisible,$1)')

/* ttlabel: A simple text label */
define(`TTdef_ttlabel',`extends(ttwidget,$1)
    field(dat,textlen)
    field(hwfont *,text)')
define(`TTFNdef_ttlabel',`extends(ttwidget,$1)
    public(byte (*SetText)($1 o, byte TT_CONST * text),SetText,$1,2,byte,$1,byte TT_CONST *)
    exported(hwfont TT_CONST *(*GetText)($1 o),GetText,$1,1,hwfont TT_CONST *,$1)')

define(`TTdef_ttanybutton',`extends(ttwidget,$1)
    field(hwfont *,text)
    field(dat,textwidth)
    field(dat,textheight)
    field(struct s_ttshape,textshape[ttbutton_shape_max])
    field(void *,MouseListener)
    field(void *,KeyListener)')
define(`TTFNdef_ttanybutton',`extends(ttwidget,$1)
    public(void (*MouseEvent)($1 o, udat Code, udat ShiftFlags, dat x, dat y),MouseEvent,$1,5,void,$1,udat,udat,dat,dat)
    public(byte (*SetText)($1 o, hwfont TT_CONST * text, dat width, dat height, dat pitch),SetText,$1,5,byte,$1,hwfont TT_CONST *,dat,dat,dat)
    exported(dat (*GetTextWidth)($1 o),GetTextWidth,$1,1,dat,$1)
    exported(dat (*GetTextHeight)($1 o),GetTextHeight,$1,1,dat,$1)
    exported(hwfont TT_CONST *(*GetText)($1 o),GetText,$1,1,hwfont TT_CONST *,$1)')

define(`TTdef_ttbutton',`extends(ttanybutton,$1)')
define(`TTFNdef_ttbutton',`extends(ttanybutton,$1)
    public(void (*SetPressed)($1 o, byte pressed),SetPressed,$1,2,void,$1)
    exported(byte (*IsPressed)($1 o),IsPressed,$1,1,byte,$1)')

define(`TTdef_ttcheckbutton',`extends(ttbutton,$1)')
define(`TTFNdef_ttcheckbutton',`extends(ttbutton,$1)')

define(`TTdef_ttradiobutton',`extends(ttcheckbutton,$1)')
define(`TTFNdef_ttradiobutton',`extends(ttcheckbutton,$1)')

define(`TTdef_ttbuttongroup',`extends(ttobj,$1)')
define(`TTFNdef_ttbuttongroup',`extends(ttobj,$1)')

define(`TTdef_ttwindow',`extends(ttwidget,$1)
    field(ttmenubar,Menubar)')
define(`TTFNdef_ttwindow',`extends(ttwidget,$1)')

/* ttframe: A toplevel window */
define(`TTdef_ttframe',`extends(ttwindow,$1)')
define(`TTFNdef_ttframe',`extends(ttwindow,$1)')

define(`TTdef_ttscrollbar',`extends(ttanybutton,$1)')
define(`TTFNdef_ttscrollbar',`extends(ttanybutton,$1)')

define(`TTdef_ttslider',`extends(ttanybutton,$1)')
define(`TTFNdef_ttslider',`extends(ttanybutton,$1)')

/* ttscroller: A scrollable container. You can put any ttwidget inside it */
define(`TTdef_ttscroller',`extends(ttwindow,$1)
    field(ttscrollbar,scrollx)
    field(ttscrollbar,scrolly)')
define(`TTFNdef_ttscroller',`extends(ttwindow,$1)')

/* ttmenuitem: Represents a single line in a menu */
define(`TTdef_ttmenuitem',`extends(ttvisible,$1)
    field(byte *,name)')
define(`TTFNdef_ttmenuitem',`extends(ttvisible,$1)')

/* ttcheckmenuitem: A checkable line in a menu. */
define(`TTdef_ttcheckmenuitem',`extends(ttmenuitem,$1)')
define(`TTFNdef_ttcheckmenuitem',`extends(ttmenuitem,$1)')

/* ttradiomenuitem: A radio line in a menu. */
define(`TTdef_ttradiomenuitem',`extends(ttcheckmenuitem,$1)')
define(`TTFNdef_ttradiomenuitem',`extends(ttcheckmenuitem,$1)')

/* ttmenuwindow: Represents a menu window */
define(`TTdef_ttmenuwindow',`extends(ttwindow,$1)')
define(`TTFNdef_ttmenuwindow',`extends(ttwindow,$1)')

/* ttmenu: Represents an entry in a menu, pointing to a ttmenuwindow */
define(`TTdef_ttmenu',`extends(ttmenuitem,$1)
    field(ttmenuwindow,menuwindow)')
define(`TTFNdef_ttmenu',`extends(ttmenuitem,$1)
    exported(ttmenuwindow (*GetMenuWindow)($1 o),GetMenuWindow,$1,1,ttmenuwindow,$1)')

/* ttmenubar: A complete menu bar. */
define(`TTdef_ttmenubar',`extends(ttvisible,$1)')
define(`TTFNdef_ttmenubar',`extends(ttvisible,$1)')

/* ttanytext: The superclass of all text-only widgets */
define(`TTdef_ttanytext',`extends(ttwindow,$1)
    field(dat,textlen)
    field(hwattr *,text)')
define(`TTFNdef_ttanytext',`extends(ttwindow,$1)')

/* tttextfield: A one-line user-editable text-only widget */
define(`TTdef_tttextfield',`extends(ttanytext,$1)')
define(`TTFNdef_tttextfield',`extends(ttanytext,$1)')

/* tttextarea: A multi-line user-editable text-only widget */
define(`TTdef_tttextarea',`extends(tttextfield,$1)')
define(`TTFNdef_tttextarea',`extends(tttextfield,$1)')

/* tttheme: The look-n-feel of the application */
define(`TTdef_tttheme',`extends(ttobj,$1)
    field(byte *,name)
    field(hwfont,fill)
    field(hwcol,bg[tttheme_bg_max])
    field(struct s_ttshape,shape[tttheme_shape_max][2])')
define(`TTFNdef_tttheme',`extends(ttobj,$1)
    protected(hwattr *(*ComputeShapeButton)(ttbutton o, byte button_i, byte theme_i),ComputeShapeButton,$1,2,hwattr *,ttbutton,byte,byte)')

/* ttapplication: The topmost object */
define(`TTdef_ttapplication',`extends(ttobj,$1)
    field(byte *,name)')
define(`TTFNdef_ttapplication',`extends(ttobj,$1)')


define(`TTlist',`el(ttobj) el(ttvisible) el(ttnative) el(ttwidget) el(ttlabel) el(ttanybutton) el(ttbutton) el(ttcheckbutton) el(ttradiobutton) el(ttbuttongroup) el(ttwindow) el(ttframe) el(ttscrollbar) el(ttslider) el(ttscroller) el(ttmenuitem) el(ttcheckmenuitem) el(ttradiomenuitem) el(ttmenuwindow) el(ttmenu) el(ttmenubar) el(ttanytext) el(tttextfield) el(tttextarea) el(tttheme) el(ttapplication)')

define(`TTnlist',`el(ttvisible) el(ttnative) el(ttwidget) el(ttlabel) el(ttanybutton) el(ttbutton) el(ttcheckbutton) el(ttradiobutton) el(ttbuttongroup) el(ttwindow) el(ttframe) el(ttscrollbar) el(ttslider) el(ttscroller) el(ttmenuitem) el(ttcheckmenuitem) el(ttradiomenuitem) el(ttmenuwindow) el(ttmenu) el(ttmenubar) el(ttanytext) el(tttextfield) el(tttextarea) el(tttheme) el(ttapplication)')



dnl defines for objects hierarchy
define(`extends',`define(`m4super_$2',`$1')')
define(`field',`')
define(`el',`TTdef_$1($1)')
TTlist()

define(`field')
define(`extends')
define(`protected')
define(`public')
define(`exported')

undefine(`el')

