<?php
/**
 * Copyright 2001-2004 by Gero Kohnert
 *
 * Create all tables indices etc for TUTOS
 *
 * !! Remove/Disable this script after running !!
 *
 * @modulegroup ADMIN
 * @module scheme
 * @package BASE
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'appointment.pinc';
 include_once 'timetrack.pinc';
 include_once 'product.pinc';
 include_once 'task.pinc';
 include_once 'mail.pinc';
 include_once 'history.pinc';

 include_once 'layout/layout.pinc';

 loadmodules("admin","install");

 /**
  * initialize database
  */
 class admin_scheme extends layout {
   /**
    * Perform Step 1  (creating tables, indexes, sequences)
    */
   Function step1() {
     global $table, $tableidx, $sequence;

     $out = 0;
     if ( $this->obj->conn != -1 ) {
       $this->assign('OpenDB', True); 
       $this->assign('obj_type', $this->obj->gettype());
       $this->assign('conn', $this->obj->conn);
     }
     else {
       $this->assign('OpenDB', False);
       return;
     }

     $this->assign('prefix', $this->obj->prefix);

     /**
      * Create tables
      */
     $tables = array();
     foreach ($table as $i => $f) {
       error_log('scheme step 1 - table '.$f[name]);

       $t = array('name' => $f[name], 'desc' => $f[Desc]);

       if ($this->obj->droptable($f) == -1) {
	 $t['del_error'] = $this->obj->lasterror;
       }
       if ($this->obj->createtable($f) == -1) {
	 $t['create_error'] = $this->obj->lasterror;
       }
       $tables[] = $t;
     }
     $this->assign('tables', $tables);

     /**
      * Create indexes
      */
     $indexes = array();
     foreach ($tableidx as $i => $f) {
       error_log('scheme step 1 - index '.$f[name]);

       $index = array('name' => $f[name], 'desc' => $f[Desc]);

       if ($this->obj->dropindex($f) == -1) {
	 $index['del_error'] = $this->obj->lasterror;
       }
       if ($this->obj->createindex($f) == -1) {
	 $index['create_error'] = $this->obj->lasterror;
       }
       $indexes[] = $index;
     }
     $this->assign('indexes', $indexes);

     /**
      * Create sequences
      */
     $seqs = array();

     foreach( $sequence as $i => $f ) {
       error_log('scheme step 1 - sequence '.$f[name]);

       $seq = array('name' => $f[name], 'desc' => $f[Desc]);

       if ( $this->obj->dropsequence($f) == -1 ) {
	 $seq['del_error'] = $this->obj->lasterror;
       }
       if ( $this->obj->createsequence($f) == -1 ) {
	 $seq['create_error'] = $this->obj->lasterror;
       }
       $seqs[] = $seq;
     }
     $this->assign('seqs', $seqs);

     // Save the Database
     // The current DB entry is always that with the ID 1
     $this->obj->db->creator = $this->user;
     $this->obj->db->newid = 1;
     $this->obj->db->id = -1;
     $this->obj->db->dbconn = &$this->obj;
     $msg = $this->obj->db->save();

     $this->assign('save_msg', $msg);
   }

   /**
    * Perform Step 2  (insert a single super user)
    */
   Function step2() {
     global $tutos;

     $msg = "";
     $tutos[demo] = 0;


     $adr = new tutos_address($this->obj);
     $adr->f_name = "Super";
     $adr->l_name = "User";
     $adr->birthday = new DateTime();
     $adr->creator = $adr;

     $q = "DELETE FROM ". $adr->tablename ." WHERE f_name = ". $adr->dbconn->String($adr->f_name) ." AND l_name = ". $adr->dbconn->String($adr->l_name);
     $adr->dbconn->exec($q);

     $msg .= $adr->save();

     $this->user = new tutos_user($this->obj);
     $this->user->updatepw = 1;
     $this->user->login = "superuser";
     $this->user->pw = "tutos";
     $this->user->id = $adr->id;
     $this->user->admin = 1;

     $q = "DELETE FROM ". $this->user->tablename ." WHERE login = ". $this->user->dbconn->String($this->user->login);
     $this->user->dbconn->exec($q);

     $msg = $this->user->save();

     $this->assign('save_msg', $msg);
   }

   /**
    * Perform Step 3  (example data)
    */
   Function step3() {
     global $lang,$tutos,$current_user;

     echo "Creating some demo data<br>\n";
     flush();
     $msg = "";
     # No mails here !!
     $tutos[demo] = 0;

     # a array to store the demo env
     $demodata = array();

     include_once('demodata.p3');

     #
     # Walk over all modules and create some demo data
     #
     # read the table definitions of modules
     foreach ($tutos[modules] as $r => $x) {
       if (!isset($tutos[modules][$r][file])) continue;
       if (file_exists(dirname($tutos['base'] ."/". $tutos[modules][$r][file]) ."/demodata.p3") ) {
         loadmodule($r);
         echo "<b>now Loading Demodata for module :<i>". $r ."</i></b><br>\n";
         @include_once dirname($tutos['base'] ."/". $tutos[modules][$r][file]) ."/demodata.p3";
       }
     }
   
     # Notes
     echo $msg ."<br>\n";
     return;
   }

   /**
    * intialize a database step by step
    */
   Function info() {
     global $tutos,$lang;

    $this->assign('title', $lang['AdminDBInfo']);

    $this->assign('dbtype',
		  array('label' => $lang['AdminDBInfo'],
			'value' => $this->obj->GetType()
			." ".$this->obj->openfunc)
		  );

    $this->assign('dbname',
		  array('label' => $lang['AdminDBName'],
			'value' => $this->obj->db->name));

    $this->assign('dbuser',
		  array('label' => $lang['AdminDBUser'],
			'value' => $this->obj->db->user));

    $this->assign('dbhost',
		  array('label' => $lang['AdminDBHost'],
			'value' => $this->obj->db->host));

    $this->assign('dbport',
		  array('label' => $lang['AdminDBPort'],
			'value' => $this->obj->db->port));

     $this->assign("id", $this->id);
     $this->assign("Enter", $lang['Enter']);
     
     if ( $this->step == 1 ) {
       $this->step1();
     }
     if ( $this->step == 2 ) {
       $this->step2();
     }
     if ( $this->step == 3 ) {
       $this->step3();
     }

     $this->template('admin/scheme');
     $this->obj->Close();
   }

   /**
    * navigate
    */
   Function navigate() {
     global $tutos, $lang;
   }

   /**
    * prepare
    */
   Function prepare() {
     global $msg, $current_user, $lang, $tutos;
     global $table, $tableidx, $sequence;

     if (isset($_GET['msg'])) { 
       $msg = $_GET['msg'];
     }
     ReadLang($lang);

     if ( ! minimum_version(minimumversion) ) {
       $msg .=
	  "<br>\nSorry TUTOS needs a PHP Version >=  "
	  . minimumversion ."<br>\n";
       $msg .= "you are using ". phpversion() ."<br>\n";
       $this->stop = true;
     }

     // read the table definitions of modules
     foreach ($tutos[modules] as $r => $x) {
       if (!isset($tutos[modules][$r][file])) continue;
       
       $mod_file =
	  dirname($tutos['base'] ."/". $tutos[modules][$r][file])
	  ."/mtable.pinc";

       if (file_exists($mod_file) ) {
         @include_once $mod_file;
         loadmodule($r);
       }
     }

     if ( isset($_GET['step']) && ($tutos[demo] == 0) ) {
       $this->step = $_GET['step'];
     }
     else {
       $this->step = 0;
     }
     $this->assign("step", $this->step);

     if ( isset($_GET['id']) ) {
       $this->id = $_GET['id'];
     }
     else {
       $this->id = 0;
       $msg .= "Using default Database ID 0  (see config.pinc)";
     }

     if ( ! isset($tutos[dbname][$this->id] ) ) {
       $msg .= "<br>The given database id ". $this->id ." is not defined in you configuration";
       $this->stop = true;
     }
     else {
       $this->obj = DB_Open($this->id,false);
     }
     
     if ( $this->stop == false ) {
       if ( $this->obj->gettype() == "Postgres" ) {
         # No persistent connections here
         $this->obj->setPersistent(0);
       }
       if ( $this->obj->gettype() == "Interbase" ) {
         # No persistent connections here
         $this->obj->setPersistent(0);
       }
     }
     $this->user = new tutos_user($this->obj);
     $this->user->f_name = "TUTOS";
     $this->user->l_name = "(installation service)";
     $this->user->admin = 1;
     $current_user = $this->user;

     /**
      * Scheme.php STEP menu
      */
     $steps = array(0 => 'Check config',
		    1 => 'Create tables',
		    2 => 'Superuser account',
		    3 => 'Demo data',
		    4 => 'TUTOS is ready');

     $this->name = $lang['DBInit'].": ".$steps[$this->step];

     foreach( $steps as $step => $title ) {
       $x = array('url'   => "admin/scheme.php?step=".$step,
		  'text'  => $title,
		  'info'  => $title,
		  'image' => $step == $this->step ? 'no-right' : 'right',
		  'category' => array("default")
		  );
       $this->addMenu($x);
     }
   }
 }


 $dbc = null;
 $x = new tutos_user($dbc);
 $l = new admin_scheme($x);
 $l->display();
?>
<!--
    CVS Info:  $Id: scheme.php,v 1.5.2.2 2005/02/09 17:15:59 tapoueh Exp $
    $Author: tapoueh $
-->