<?php
/* Display a PNG Gantt.
 * This file needs to just do that, cause the content-type will be set to
 * image/png.
 *
 * This fonctionnality needs the JpGraph tool, a PHP4 Chart librairie,
 * released under the GPL.
 *
 * $Author: tapoueh $
 *
 * $Id: gantt_png.php,v 1.22.2.4 2005/04/07 16:43:24 tapoueh Exp $
 */

include_once 'webelements.p3';
include_once 'permission.p3';
include_once 'task.pinc';
include_once 'product.pinc';
include_once 'timetrack.pinc';

/* Check if user is allowed to use it */
check_user();
session_write_close();

class gantt_png {

  function gantt_png($dbconn, $id) {
    $this->dbconn = $dbconn;
    $this->obj    = GetObject($dbconn, $id);

    $this->state = -1;
    $this->start = new DateTime(0);
    $this->end   = new DateTime(0);

    /**
     * Get the filter parameters
     */
    if( isset($_GET['state']) )
      $this->state = $_GET['state'];
  
    if ( isset($_REQUEST['start']) ) {
      $this->start->setDateTime($_REQUEST['start']);
    }
    else {
      if( isset($_REQUEST['start_d']) ) {
	$this->start->setDateTimeF('start');
	$_SESSION['tasksearchfrom'] = $this->start->getYYYYMMDD();
      }
    }
  
    if ( isset($_REQUEST['end']) ) {
      $this->end->setDateTime($_REQUEST['end']);
    }
    else {
      if( isset($_REQUEST['end_d']) ) {
	$this->end->setDateTimeF('end');
	$_SESSION['tasksearchto'] = $this->end->getYYYYMMDD();
      }
    }
  }

  function get_bar(&$task, $n, $depth) {
    global $font;

    $s = $task->get_s_start();
    $e = $task->get_s_end();

    $name  = $task->name;
    $start = $s->getYYYYMMDD();
    $end   = $e->getYYYYMMDD();
    $vol   = $task->get_volume_done();
    $comp  = $task->getcompletion();

    for ($i = 1; $i < $depth; $i++) {
      $name = "  ".$name;
    }
  
    if( $task->milestone ) {
      $bar = new MileStone($n, $name, $start);
    }
    else {
      $bar = new GanttBar($n, $name, $start, $end,
			  sprintf("[%.0f %%]", $comp), 0.5);

      if ( $comp > 100.0 ) {
	$comp = 100.0;
      
	$bar->SetColor("red");
	// $bar->SetFillColor("white");
	$bar->SetPattern(BAND_RDIAG, "red");
	// $bar->progress->SetPattern(BAND_RDIAG, "red"); 
      }
      $bar->progress->Set($comp/100.0);

      if( $task->logical ) {
	$bar->rightMark->Show();
	$bar->rightMark->SetType(MARK_RIGHTTRIANGLE);
	$bar->rightMark->SetWidth(8);
	$bar->rightMark->SetColor('black');
	$bar->rightMark->SetFillColor('black');
	    
	$bar->leftMark->Show();
	$bar->leftMark->SetType(MARK_LEFTTRIANGLE);
	$bar->leftMark->SetWidth(8);
	$bar->leftMark->SetColor('black');
	$bar->leftMark->SetFillColor('black');

	$bar->SetPattern(BAND_SOLID, "black");
	$bar->SetHeight(6);
      }
    }

    /* Outline first level tasks */
    $bar->title->SetFont($font, FS_NORMAL, 8); 
    if( $depth == 1 ) {
      $bar->title->SetFont($font, FS_BOLD, 8);
    }

    return $bar;
  }

  /* Recursive adding of project tasks */
  function addTasks(&$parent, &$graph, &$count, $depth) {
    if ( $parent->getType() == "task"
	 && $parent->filter($this->state, $this->start, $this->end) ) {
      $graph->Add($this->get_bar($parent, $count++, $depth));
    }

    $parent->readTasks();
    @reset($parent->tasklist);
    while( list($i, $f) = @each($parent->tasklist) ) {
      $graph = $this->addTasks($f, $graph, $count, $depth+1);
    }
    return $graph;
  }

  Function draw() {
    global $lang, $font, $tutos;

    task_calc($this->obj);

    // Standard calls to create a new graph
    $graph = new GanttGraph();
    //$graph->SetShadow();
    $graph->SetBox();
    // Titles for chart
    $graph->title->Set($lang['TaskGantt']." ". $lang['forphrase'] ." " .
		       html_entity_decode($this->obj->getFullName()) );

    $graph->title->SetFont($font,FS_BOLD,12);

    // For illustration we enable all headers. 
    $graph->ShowHeaders(GANTT_HMONTH | GANTT_HDAY | GANTT_HWEEK);

    $graph->scale->week->SetStyle(WEEKSTYLE_FIRSTDAY);
    $graph->scale->month->SetStyle(MONTHSTYLE_LONGNAMEYEAR4);

    /* TODO: we could use locale */
    // $graph->scale->SetDateLocale("fr_FR");

    // Change the scale font 
    $graph->scale->week->SetFont(FF_FONT0);
    $graph->scale->year->SetFont(FF_ARIAL,FS_BOLD,12);

    $count = 0;
    $graph = $this->addTasks($this->obj, $graph, $count, 0);

    // Add a vertical line for the current day
    $vline = new GanttVLine(strftime("%Y-%m-%d", time()));
    $vline->SetDayOffset(0.5);
    $graph->Add($vline);

    $graph->Stroke();
  }
}

// we try both places
$jpsrc = 'jpgraph.php';
$base_path = getcwd()."/".$tutos['base']."/php/";

if( file_exists($tutos[jpgraph]."/".$jpsrc) ) {
  include $tutos[jpgraph]."/jpgraph.php";
  include $tutos[jpgraph]."/jpgraph_gantt.php";
}
else if( file_exists($base_path.$tutos[jpgraph]."/jpgraph.php") ) {
  include $tutos[jpgraph]."/jpgraph.php";
  include $tutos[jpgraph]."/jpgraph_gantt.php";
}
else {
  include $tutos[jpgraph]."/src/jpgraph.php";
  include $tutos[jpgraph]."/src/jpgraph_gantt.php";
}

#
# If we use a non western laguage encoding force the use of truetype fonts
#
if ($lang['content_encoding'] != "iso-8859-1") {
  $font = FF_ARIAL;
} else {
  $font = FF_FONT1;
}

if ( isset($_GET['id']) ) {
  $gantt = new gantt_png($dbconn, $_GET['id']);
  $gantt->draw();
}
else {
  $msg = $lang['Err0048'];
  $stop = 1;
  $obj = $id;

  echo $msg;
}

$dbconn->Close();

?>
