<?php
/**
 * Copyright 1999 - 2004 by Gero Kohnert
 *
 * @modulegroup bug
 * @module bug_select
 * @package bug
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'bug.pinc';

 require_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("bugtracking","select");
 loadmodule("bugtracking");

 /**
  * display a bug selection form
  */
 class bug_select extends layout {

   /**
    *
    */
   Function info() {
     global $lang,$tutos;

     $this->assign('action', "bug_overview.php");
     $this->assign('ext', $this->ext);

     if( $this->ext == 0 ) {
       $this->assign('title', $lang['SearchForBug']);

       $this->assign('name',
		     array('id'    => 'name',
			   'label' => $lang['AdrName'],
			   'value' => ""));


       $this->assign('search',
		     array('label' => $lang['Search'],
			   'title' => $lang['SearchForBug']));

       $this->assign('info', $lang['BugSelInfo']);
       
       $this->assign('extlink',
		     array('label' => $lang['extended'],
			   'link'  => "bug_select.php?ext=1",
			   'title' => $lang['extended']));
     }
     else {
       $this->assign('title', $lang['SearchForBugExt']);
       
       $this->assign('adrname',
		     array('id'    => 'name',
			   'label' => $lang['AdrName'],
			   'value' => ""));

       $this->assign('search',
		     array('label' => $lang['Search'],
			   'title' => $lang['SearchForBugExt']));

       $states = array();
       $states[-1] = $lang['any'];
       $states[-2] = $lang['BugAnyButClosed'];
       foreach($lang['BugStates'] as $i => $f)
	 $states[$i] = $f;

       $this->assign('state',
		     array('id'      => 'state',
			   'label'   => $lang['BugState'],
			   'options' => $states));

       $classes = array();
       $classes[-1] = $lang['any'];
       foreach($lang['BugClasses'] as $i => $f)
	 $classes[$i] = $f;

       $this->assign('class',
		     array('id'      => 'class',
			   'label'   => $lang['BugClass'],
			   'options' => $classes));

       $this->assign_date($lang['BugBetween'], "f");
       $this->assign_date("", "t");

       $this->assign('solver',
		     array('id'     => 'solverid',
			   'label'  => sprintf($lang['UserBugSearch'],
					       $this->user->getFullName()),
			   'title'  => $this->user->getFullName(),
			   'link'   => $base."/php/".$this->user->getUrl(),
			   'value'  => $this->user->id));

     }

     /**
      * Products buginfos
      */
     $bugs     = array();
     $projects = product::infolist($this->user, $this->user, True);

     foreach( $projects as $pid => $pdesc ) {
       $project = new product();
       $project->read($pid);

       $buglist = bug::infolist($this->user, $project);

       if( count($buglist['summary']) > 0 )
	 $bugs[] = array('name'  => $pdesc['name'],
			 'link'  => $pdesc['link'],
			 'title' => $pdesc['title'],
			 'bugs'   => $buglist);
     }
     // $this->debug($bugs);
     $this->assign('hours', $lang['hours']);
     $this->assign('bugs', $bugs);
     $this->template('bugtracking/bug_select');
   }

   /**
    *
    */
   Function navigate() {
   }

   /**
    *
    */
   Function prepare() {
     global $lang,$tutos;
     $this->name =  $lang['BugsSearch'];

     if ( ! $this->user->feature_ok(usebugtracking,PERM_SEL) ) {
       $msg .= sprintf($lang['Err0022'],"'". $this->name ."'");
       $this->stop = true;
	 }

     # Defaults for search
     $this->from = new DateTime(0);
     $this->to = new DateTime(0);
	 
     if ( isset($_SESSION['bugsearchfrom']) ) {
       $this->from->setDateTime($_SESSION['bugsearchfrom']);
     }
     if ( isset($_SESSION['bugsearchto']) ) {
       $this->to->setDateTime($_SESSION['bugsearchto']);
     }
     if ( isset($_SESSION['bugsearchclass']) ) {
       $this->class = $_SESSION['bugsearchclass'];
     } else {
       $this->class = -1;
     }
     if ( isset($_SESSION['bugsearchstate']) ) {
       $this->state = $_SESSION['bugsearchstate'];
     } else {
       $this->state = -1;
     }
     if ( ! isset($_GET['ext']) ) {
       $this->ext = 0;
     } else {
	   $this->ext = $_GET['ext'];
     }
     if ( $this->user->feature_ok(usebugtracking,PERM_NEW) ) {
       $x = array('url'   => "bugtracking/bug_new.php",
                  'text'  => $lang['NewEntry'],
		  'image' => 'new',
                  'info'  => $lang['CreateNewBug'],
                  'category' => array("bug","new","obj")
                 );
       $this->addMenu($x);
     }
   }
 }

 $l = new bug_select($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: bug_select.php,v 1.1.2.5 2005/03/02 10:29:45 tapoueh Exp $
    $Author: tapoueh $
-->