<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup bug
 * @module bug_new
 * @package bug
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'bug.pinc';
 include_once 'product.pinc';
 include_once 'task.pinc';
 include_once 'timetrack.pinc';

 require_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("bugtracking","new");
 loadmodule("bugtracking");

 /**
  * change/modify a bug
  */
 class bug_new extends layout {
   /**
    * display the form
    */
   Function info() {
     global $lang,$tutos,$table;

     $this->assign('action', 'bug_ins.php');
     $this->assign('title', sprintf($lang['Showing'],
				    $lang[$this->obj->getType()]));

     $this->assign('id',    $this->obj->id);

     if( $this->obj->id ) {
       $this->assign('created',
		     sprintf($lang['BugCreation'],
			     $this->obj->creator->getLink(),
			     $this->obj->creation->getDateTime()));

     }

     // Bug Autoname management
     if( $tutos[bugautoname] != "" ) {
       $this->assign('name', 'auto');
       if( $this->obj->id < 1 )
	 $name = $lang['BugAutoID']." ".strftime($tutos[bugautoname]);
       else
	 $name = $this->obj->name;
     }     

     $this->assign('name',
		   array('id'    => 'name',
			 'auto'  => $tutos[bugautoname] != "",
			 'label' => $lang['BugID'],
			 'value' => $this->obj->name,
			 'info'  => $name));


     /**
      * Edit state, then class
      *  state is not editable on bug creation
      */
     if( $this->obj->id > 0 ) {
       $states = array();
       foreach($lang['BugStates'] as $i => $f)
	 $states[$i] = $f;

       $this->assign('state',
		     array('id'       => 'state',
			   'label'    => $lang['BugState'],
			   'options'  => $states,
			   'selected' => $this->obj->state));
     }
     else {
       $this->assign('state',
		     array('id'    => 'state',
			   'label' => $lang['BugState'],
			   'value' => $this->new_hist->state,
			   'info'  => $lang['BugAutoState']));

     }

     // Class is editable as soon as init
     $classes = array();
     foreach($lang['BugClasses'] as $i => $f)
       $classes[$i] = $f;

     if( $this->obj->id > 0 )
       $class = $this->obj->class;
     else
       $class = $this->new_hist->class;

     $this->assign('class',
		   array('id'       => 'class',
			 'label'    => $lang['BugClass'],
			 'options'  => $classes,
			 'selected' => $class));
     
     $this->assign('desc',
		   array('id'    => 'short',
			 'label' => $lang['BugShort'],
			 'size'  => min(40,$table['bug']['short'][size]),
			 'maxl'  => $table['bug']['short'][size],
			 'value' => myentities($this->obj->short)));


     // Set the solver of the bug
     if ( $this->obj->id > 0 ) {
       $obj = $this->obj->solver;
     }
     else {
       if( $this->obj->parent->id > 0 ) {
	 if( $this->obj->parent->getType() == "product" ) {
	   $this->obj->parent->readroles();
	   reset($this->obj->parent->role[PROD_ROLE_MANAGER]);
	   reset($this->obj->parent->role[PROD_ROLE_MANAGER2]);
	   if( count($this->obj->parent->role[PROD_ROLE_MANAGER]) > 0 ) {
	     $obj  = current($this->obj->parent->role[PROD_ROLE_MANAGER]);
	   }
	   else if( count($this->obj->parent->role[PROD_ROLE_MANAGER2]) > 0) {
	     $obj  = current($this->obj->parent->role[PROD_ROLE_MANAGER2]);
	   }
	   else {
	     $obj  = $this->user;
	   }
	 }
	 else if( $this->obj->parent->getType() == "installation" ) {
	   $this->obj->parent->product->readroles();
	   reset($this->obj->parent->product->role[PROD_ROLE_MANAGER]);
	   reset($this->obj->parent->product->role[PROD_ROLE_MANAGER2]);
	   if( count($this->obj->parent->product->role[PROD_ROLE_MANAGER]) >0 ) {
	     $obj  = current($this->obj->parent->product->role[PROD_ROLE_MANAGER]);
	   }
	   else if(count($this->obj->parent->product->role[PROD_ROLE_MANAGER2]) > 0)  {
	     $obj  = current($this->obj->parent->product->role[PROD_ROLE_MANAGER2]);
	   }
	   else {
	     $obj  = $this->user;
	   }
	 }
	 else if ( $this->obj->parent->getType() == "task" ) {
	   foreach( $this->obj->parent->worker as $i => $f ) {
	     $obj  = $this->obj->parent->worker[$i];
	     break;
	   }
	 }
	 else {
	   $obj = $this->user;
	 }
       }
       else {
         $obj = $lang['Product'] ." ". $lang['ProdRole'][1];
       }
     }

     if( is_object($obj) && $obj->id > 0 && $this->obj->parent->id > 0 ) {

       // Give a participants select list to choose the bug solver
       // We want a list without people id (False)

       // Preselecting the estimated solver
       $selected = array($obj->getFullName());

       if( $this->obj->parent->getType() == "product" ) {
	 $parts = $this->user->askPeople($selected, $this->obj->parent, False);
       }
       else if( $this->obj->parent->getType() == "task" ) {
	 $tasks   = array();
	 $project = $this->obj->parent->getProject($tasks);
	 $parts   = $this->user->askPeople($selected, $project, False);
       }
       else
	 $parts = $this->user->askPeople($selected, -1, False);

       // $this->debug($parts);

       // $this->assign('sid', $obj->id);
       $this->assign('solver',
		     array('id'      => 's',
			   'name'    => 'sfn',
			   'label'   => $lang['BugAssignedTo'],
			   'options' => $parts));

       /*
       $this->assign('solver',
		     array('id'    => 's',
			   'name'  => 'sfn',
			   'label' => $lang['BugAssignedTo'],
			   'value' => $obj->getFullName(),
			   'title' => $obj->getFullName(),
			   'link'  => $obj->getUrl()));
       */
     }
     else {
       $this->assign('sid', $this->user->id);
       $this->assign('solver',
		     array('id'    => 's',
			   'label' => $lang['BugAssignedTo'],
			   'value' => $obj));
     }

     // References
     $this->assign_parent_select('ref');

     $this->assign('volume',
		   array('name'  => 'volume',
			 'label' => $lang['TaskVolumeDone'],
			 'value' => number_format($this->obj->volume, 2,
						  $lang['DecPoint'],
						  $lang['ThousandPoint'])));
     $this->assign('newdesc',
		   array('id'    => 'description',
			 'label' => $lang['BugLong'],
			 'value' => $this->obj->newdesc));

     // Bug History
     $history = $this->obj->prepare_history($this->order == "reverse");

     // $this->debug($history);
     $this->assign('history',
		   array('label' => $lang['BugHistory'],
			 'value' => $history));

     $this->assign('BugClass',      $lang['BugClass']);
     $this->assign('BugState',      $lang['BugState']);
     $this->assign('BugAssignedTo', $lang['BugAssignedTo']);
     $this->assign('BugCreator',    $lang['BugCreator']);
     $this->assign('Date',          $lang['Date']);
     $this->assign('hours',         $lang['hours']);


     $this->assign('InputOk',   $lang['InputOk']);
     $this->assign('ChangesOk', $lang['ChangesOk']);
     $this->assign('Enter', $lang['Enter']);
     $this->assign('Reset', $lang['Reset']);

     $this->assign('FldsRequired', $lang['FldsRequired']);
     $this->template('bugtracking/bug_new');
   }

   /**
    * navigate
    */
   Function navigate() {
   }

   /**
    * prepare
    */
   Function prepare() {
     global $tutos,$lang,$msg;

     /**
      * We manipulate a bug and a new history item for it
      */
     $this->obj      = new bug($this->dbconn);
     $this->new_hist = new bugdata($this->dbconn);

     $this->obj->newdesc = "";

     $this->order = "reverse";

     if ( isset($_GET['id'])  && ($_GET['id'] > 0) ) {
       $this->obj->read($_GET['id']);
       $this->obj->read_bughistory();
       if ($this->obj->id < 0) {
         $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
         $this->stop = true;
       }
       $this->name = sprintf($lang['BugModifyI'],$this->obj->getFullName());
     } else {
       $this->name = $lang['BugCreate'];
     }

     if ( isset($_GET['description']) ) {
       $this->obj->newdesc = StripSlashes($_GET['description']);
     }
     if ( isset($_GET['volume']) ) {
       $this->obj->volume = $_GET['volume'];
     }
     if ( isset($_GET['short']) ) {
       $this->obj->short = StripSlashes($_GET['short']);
     }
     if ( isset($_GET['state']) ) {
       $this->obj->state = $_GET['state'];
     }
     if ( isset($_GET['class']) ) {
       $this->new_hist->class = $_GET['class'];
     }
     if ( isset($_GET['pid']) ) {
       $this->obj->parent = getObject($this->dbconn,$_GET['pid']);
     }
     # Get possible new references
     $this->obj->read_relations();

     # Get the solver
     preset_from_array_or_input($this->obj,'solver',"s");

     if ( $this->obj->id < 0 ) {
       if ( !$this->user->feature_ok(usebugtracking,PERM_NEW) ) {
         $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
         $this->stop = true;
       }
     } else {
       if (! $this->obj->mod_ok() ) {
         $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
         $this->stop = true;
       }
     }
     # menu stuff
     $x = bug::getSelectLink($this->user,$lang['Search']);
     $x['category'][] = "obj";
     $x['image'] = "search";
     $this->addmenu($x);

     if ( $this->user->feature_ok(usebugtracking,PERM_NEW) ) {
       $x = array('url'   => "bugtracking/bug_new.php",
                  'text'  => $lang['NewEntry'],
		  'image' => 'new',
                  'info'  => $lang['CreateNewBug'],
                  'category' => array("bug","new","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array('url'     => $this->obj->getDelURL(),
                  'text'    => $lang['Delete'],
		  'image'   => 'delete',
                  'confirm' => true,
                  'info'    => sprintf($lang['BugDeleteI'],
				       $this->obj->getFullname()),
                  'category' => array("bug","del","obj")
                 );
       $this->addMenu($x);
     }

     if ( ($this->obj->id > 0) && $this->obj->mod_ok() ) {
       $x = array( 'url'   => "acl_show.php?id=".$this->obj->id,
                   'text'  => $lang['AclDetail'],
		   'image' => 'acls',
                   'info'  => sprintf($lang['AclDetailI'],
				      $this->obj->getFullname()),
                   'category' => array("acl","obj")
                 );
       $this->addMenu($x);
     }

     add_module_newlinks($this,$this->obj);
     web_StackStartLayout($this,"bug_new.php","bug_new.php?".$_SERVER['QUERY_STRING']);     
   }
 }

 $l = new bug_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: bug_new.php,v 1.5.2.13 2005/03/07 16:21:11 tapoueh Exp $
    $Author: tapoueh $
-->