<?php
/**
 * Copyright 2002 - 2004 by Gero Kohnert
 *
 * Update all tables indices etc for TUTOS
 *
 * !! Remove/Disable this script after running !!
 *
 * @modulegroup ADMIN
 * @module update
 * @package BASE
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 include_once 'layout/layout.pinc';

 loadmodules("admin","update");

 /**
  * display a update output
  */
 class admin_update extends layout {

   /**
    * display the info
    */
   Function info() {
     global $table, $tableidx, $sequence, $tutos;

     $this->assign('id', $this->id);

     if( $this->id == -1 ) {
       // No database has been choosen
       $this->template('admin/update');
       return;
     }

     $this->assign('name', $this->dbc->getFullName());

     $tables = array();
     foreach ($table as $i => $f) {
       if ($this->dbc->createtable($f) == -1) {
         if ( $tutos[debug] != 0 ) {
	   $tables[] = array('name'  => $f[name],
			     'desc'  => $f[Desc],
			     'mesg'  => "not created",
			     'error' => $this->dbc->lasterror);
         }
       }
       else { 
	 $tables[] = array('name' => $f[name],
			   'desc'  => $f[Desc],
			   'mesg' => "created");
       }
     }
     $this->assign('tables', $tables);


     $cols = array();
     foreach ($table as $i => $f) {
       foreach( $f as $i2 => $f2 ) {
         if ( ! is_array($f2) ) {
           continue;
         }
         if ($this->dbc->createcolumn($f[name],$i2,$f2) == -1) {
           # nothing created (try an alter table to fix sizes)
         }
	 else {
	   $cols[] = array('table' => $f[name],
			   'desc'  => $f[Desc],
			   'name'  => $i2);
         } 
       }
     }
     $this->assign('cols', $cols);

     $indexes = array();
     foreach( $tableidx as $i => $f ) {
       if ($this->dbc->createindex($f) != -1) {
	 $indexes[] = array('name' => $f[name],
			    'desc' => $f[desc]);
       }
     }
     $this->assign('indexes', $indexes);

     $seqs = array();
     foreach( $sequence as $i => $f ) {
       if ($this->dbc->createsequence($f) != -1) {
	 $seqs[] = array('name' => $f[name],
			 'desc' => $f[Desc]);
       }
     }
     $this->assign('seqs', $seqs);

     // Update the DB entry
     // The current DB entry is always that with the ID 1
     $this->dbc->db->read_update();

     $this->assign('db_version', $this->dbc->db->version);
     $this->assign('tutos_version', $tutos[version]);

     $oldv =  ereg_replace("[a-z\.]","",$this->dbc->db->version);
     $newv =  ereg_replace("[a-z\.]","",$tutos[version]);

     if ( $oldv < 1120021026 ) {
       $this->assign('special_update', True);

       #special update
       $updatefailed = false;

       $tmpname = 'acl_temp';
       # drop temp table
       if ($this->dbc->droptable($tmpname) == -1) {
       }
       if ($this->dbc->dropindex($tableidx['acl1']) == -1) {
       }
       if ($this->dbc->dropindex($tableidx['acl2']) == -1) {
       }
       # rename acl
       if ($this->dbc->renametable($table['acl'],$tmpname) == -1) {
         $updatefailed = drue;
	 $this->assign('acl_rename_error', $this->dbc->lasterror);
       }
       # create acl
       if ($this->dbc->createtable($table['acl']) == -1) {
         $updatefailed = true;
	 $this->assign('acl_create_error', $this->dbc->lasterror);
       }
       if ($this->dbc->createindex($tableidx['acl1']) == -1) {
         $updatefailed = true;
	 $this->assign('acl1_index_create_error', $this->dbc->lasterror);
       }
       if ($this->dbc->createindex($tableidx['acl2']) == -1) {
         $updatefailed = true;
	 $this->assign('acl2_index_create_error', $this->dbc->lasterror);
       }

       // fill
       $q = "insert into ". $this->dbc->prefix . $table['acl'][name] ." (obj_id,adr_id,perm)";
       if ( $this->dbc->getType() == "Postgres" ) {
         $q .= " select obj_id,adr_id,int4(perm) from ". $this->dbc->prefix . $tmpname;
       } else {
         $q .= " select obj_id,adr_id,perm from ". $this->dbc->prefix . $tmpname;
       }
       $this->dbc->Exec($q,0);
       if ( $updatefailed )
	 $this->assign('acl_update_failed', True);
       else
	 $this->assign('acl_update_failed', False);
     }
     else
       $this->assign('special_update', False);

     $this->dbc->db->SetVersion($tutos[version]);
     $this->dbc->db->save();

     $this->template('admin/update');
   }

   /**
    * navigate
    */
   Function navigate() {
   }

   /**
    * prepare
    */
   Function prepare() {
     global $table,$sequence,$tableidx,$tutos,$msg,$lang;

     if ( ! minimum_version(minimumversion) ) {
       $msg .= "<br>\nSorry TUTOS needs a PHP Version >=  ". minimumversion ."<br>\n";
       $msg .= "you are using ". phpversion() ."<br>\n";
       $this->stop = true;
     }

     if (  isset($_GET['id']) ) {
       if ( $this->user->id == -1 ) {
          ReadLang($lang);
       }
       if ( isset($tutos[dbname][$_GET['id']] ) ) {
	 $this->id  = $_GET['id'];
         $this->dbc = DB_Open($this->id, false);
       }
       else {
         $msg .= 
	    "<br>The given database id ". $_GET['id'] .
	    " is not defined in you configuration";
         $this->stop = true;
       }
     }
     else {
       /* Check if user is allowed to use it */
       $this->id = -1;
       $this->assign('id', -1);

       $databases = array();
       foreach( $tutos[dbname] as $i => $name ) {
	 $databases[] = array('id'    => $i,
			      'name'  => $name,
			      'host'  => $tutos[dbhost][$i],
			      'alias' => $tutos[dbalias][$i]);
       }
       // $this->debug($databases);
       $this->assign('databases_title',
		     "Please add a Database ID like ?id=0 to the URL");
       $this->assign('databases', $databases);
     }

     # read the table definitions of modules
     foreach ($tutos[modules] as $r => $x) {
       $file = dirname($tutos['base'] ."/". $tutos[modules][$r][file])
	  ."/mtable.pinc";

       if( isset($tutos[modules][$r][file]) && file_exists($file) ) {
         @include_once $file;
       }
     }
     $this->name = $lang['DBUpdate'];

     if ( $tutos[demo] != 0 ) {
       $msg .= "will not work in demo";
       $this->stop = true;
     }
   }
 }

 $dbc = null;
 $x = new tutos_user($dbc);
 $current_user = &$x;

 $l = new admin_update($x);
 $l->display($withmenu = False);
?>
<!--
    CVS Info:  $Id: update.php,v 1.2.2.2 2005/02/09 17:15:59 tapoueh Exp $
    $Author: tapoueh $
-->
