<?php
/*
 * Copyright 2002 by Gero Kohnert
 *
 * a calendar for a single day
 *
 * @modulegroup appointment
 * @module calendar_day
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'task.pinc';
 include_once 'appointment.pinc';
 include_once 'product.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("appointment","show");
 loadlayout();

 /**
  * display a calendar for one single day
  */
 class calendar_day extends layout {
   /**
    * the data display part
    */
   Function info() {
     global $lang,$tutos;

     $ts = mktime(12,0,0,substr($this->t,4,2),substr($this->t,6,2),substr($this->t,0,4));
     $from = new DateTime();
     $from->setDateTimeTS($ts);


     $last_day = $from;
     $next_day = $from;
     $next_day->addDays(1);
     $last_day->addDays(-1);

     $wn = sprintf("%02d", Round( (Date("z",$ts)+7 ) / 7) );
     $yy = Date("y",$ts);


     $this->user->callist = array();
     appointment::readCal($this->user,$from,$next_day);
     task::readCal($this->user,$from,$next_day);

     foreach($tutos[activemodules] as $i => $f) {
       $x = &new $tutos[modules][$f][name]($this->dbconn);
       $x->readCal($this->user,$from,$next_day);
     }

     for ($i = -1 ; $i < 24 ; $i++ ) {
       $table[$i] = array();
     }
     $x = count( $this->user->callist );
     for ( $a = 0 ; $a < $x ; $a++) {
       if ( ! $this->user->callist[$a]->inside($from)) {
         continue;
       }
       if (!cal_check_against_list($this->user->callist[$a],$this->uids)) {
         continue;
       }
       if ( $this->user->callist[$a]->gettype() == "note" ) {
         $table[-1][] = &$this->user->callist[$a];
         $rowspan[-1][] = 1;
         continue;
       }
       if ( $this->user->callist[$a]->gettype() == "watchlist" ) {
         $table[-1][] = &$this->user->callist[$a];
         $rowspan[-1][] = 1;
         continue;
       }
       if ( $this->user->callist[$a]->gettype() == "task" ) {
         $table[-1][] = &$this->user->callist[$a];
         $rowspan[-1][] = 1;
         continue;
       }
       if ( $this->user->callist[$a]->t_ignore == 1) {
         $table[-1][] = &$this->user->callist[$a];
         $rowspan[-1][] = 1;
         continue;
       }
       if ( ($this->user->callist[$a]->s_out == 1) && ($this->user->callist[$a]->e_out == 1) ) {
         $table[-1][] = &$this->user->callist[$a];
         $rowspan[-1][] = 1;
         continue;
       }
       $x1 = Date("G",$this->user->callist[$a]->start->getTimeStamp());
       $x2 = Date("G",$this->user->callist[$a]->end->getTimeStamp());

       if ( $this->user->callist[$a]->s_out == 1 ) {
         $x1 = 0;
       }
       if ( $this->user->callist[$a]->e_out == 1 ) {
         $x2 = 23;
       }
       # find a free position
       $pos = -1;
       $found = false;
       while ( $found == false ) {
         $found = true;
         $pos ++;
         for ( $i = $x1; $i <= $x2 ; $i++ ) {
           if (isset($table[$i][$pos]) ) {
             $found = false;
             continue;
           }
         }
       }
       for ( $i = $x1; $i <= $x2 ; $i++ ) {
         if ( $i == $x1 ) {
           $table[$i][$pos] = &$this->user->callist[$a];
           $rowspan[$i][$pos] = ($x2 - $x1 +1);
         } else {
           $table[$i][$pos] = -1;
         }
       }
     }
     $maxcol = 1;
     for ($i = -1 ; $i < 24 ; $i++ ) {
       $maxcol = max($maxcol,count($table[$i]));
     }

     echo "<form action=\"calendar_day.php\" method=\"GET\">\n";
     echo "<table class=\"single\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"90%\">\n";
     echo " <tr>\n";
     echo "  <th align=\"left\" nowrap colspan=\"". ($maxcol +1) ."\">&nbsp;". $lang['forphrase'] ."\n";
     cal_options($this->team,$this->teamname);
     echo "  </th>\n";
     echo " </tr>\n";
     echo " <tr>\n";
     echo " <th nowrap colspan=\"". ($maxcol +1) ."\" width=\"100%\">";
     echo menulink("calendar_day.php?t=".$last_day->getYYYYMMDD(),$this->theme->getImage(left,'list'),$last_day->getDate());
     echo "&nbsp;". strftime($lang['DateFormatTitle'],$from->ts) ."&nbsp;(". $lang['week']." ". menulink("calendar_week.php?t=".Date("Ymd",$from->ts), $wn ."/". $yy, $wn ."/". $yy ) .")&nbsp;";
     echo menulink("calendar_day.php?t=".$next_day->getYYYYMMDD(),$this->theme->getImage(right,'list'),$next_day->getDate());
     echo "</th></tr>\n";
     for ($i = -1 ; $i <24 ; $i++ ) {
       echo " <tr>\n";

       echo " <th width=\"10%\" align=\"right\" valign=\"top\">\n";
       if ( $i == -1 ) {
         echo  menulink("app_new.php?t=".$this->t, "NOTIME",$lang['NewAppointInfo']);
       } else {
         echo  menulink("app_new.php?start=". $this->t.sprintf("%02d",$i)."00&end=".$this->t.sprintf("%02d",$i)."59" ,sprintf("%02d", $i).":00",$lang['NewAppointInfo']);
       }
       echo "&nbsp;</th>\n";

       for ($c = 0 ; $c < $maxcol ; $c++ ) {
         if ( isset ( $table[$i][$c] ) ) {
           if ( is_object ( $table[$i][$c] ) ) {
             echo " <td class=\"line". (1+($i % 2)) ."\" valign=\"top\" rowspan=\"". $rowspan[$i][$c]."\">";
             echo "<img height=\"1\" width=\"100%\" src=\"". $tutos['base'] ."/html/black.png\" alt=\"--------\"><br>";
             echo "&nbsp;<center><table class=\"line". (1+($i % 2)) ."\" width=\"90%\" border=\"0\" cellpadding=\"1\" cellspacing=\"0\">\n";
             echo $table[$i][$c]->formatted();
             echo " </table></center></td>\n";
           } else if ( $table[$i][$c] = -1 ) {
             # SKIP occupied by rowspan
           }
         } else {
           echo "<td class=\"line". (1+($i % 2)) ."\" valign=\"top\"><img height=\"1\" width=\"100%\" src=\"". $tutos['base'] ."/html/black.png\" alt=\"--------\"></td>";
         }
       }
       echo " </tr>\n";
     }
     echo $this->DataTableEnd();
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $tutos, $lang,$msg;

     $this->name = $lang['Calendar'];
     $this->teamname = "";
     $this->t = Date("Ymd");

     if ( isset ($_GET['t']) ) {
       $this->t = $_GET['t'];
     }
     $this->addHidden("t", $this->t);
     $this->uids = cal_parse_options($this->user,$this->teamname);
     $this->team = $this->user->get_prefteam();
     # menu
     $m = appointment::getSelectLink($this->user);
	 $m[category][] = "obj";
     $this->addmenu($m);
     $m = appointment::getAddLink($this->user,$this->user);
     $this->addMenu($m);
   }
 }


# info($t,$this->user->get_prefteam(),$teamname,$uids);

 $l = new calendar_day($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: calendar_day.php,v 1.26.2.2 2003/10/14 16:16:31 gokohnert Exp $
    $Author: gokohnert $
-->
