////////////////////////////////////////////////////////////////////////////////
// TunnelX -- Cave Drawing Program
// Copyright (C) 2002  Julian Todd.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
////////////////////////////////////////////////////////////////////////////////
package Tunnel;

import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.DefaultListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;

import java.awt.event.MouseListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseAdapter;

import javax.swing.JScrollPane;
import javax.swing.JPanel;
import java.awt.BorderLayout;

import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import java.awt.Component;
import javax.swing.JSplitPane;

import java.awt.Color;
import java.util.List;
import java.io.IOException;

import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeNode;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

//
//
//
//

/////////////////////////////////////////////
class DefaultMutableTreeNodeFile extends DefaultMutableTreeNode
{
	FileAbstraction fa = new FileAbstraction(); 
    boolean bdirnodeloaded = false; 
	DefaultMutableTreeNodeFile(FileAbstraction lfa)
	{
		super(lfa.getAbsolutePath());
        fa = lfa; 
	}
	public String toString()
	{
        return fa.getName() + " (" + fa.xfiletype + ")";
	}
}



/////////////////////////////////////////////
// this class will encapsulate all the mess that is the left hand side of the mainbox
class TunnelFileList extends JPanel implements ListSelectionListener, MouseListener, TreeSelectionListener
{
	MainBox mainbox;

	DefaultListModel tflistmodel;
	JList tflist;
	final static Color[] colNotLoaded = { new Color(1.0F, 1.0F, 1.0F), new Color(0.7F, 0.8F, 0.9F) };
	final static Color[] colLoaded = { new Color(0.8F, 1.0F, 0.8F), new Color(0.2F, 1.0F, 0.3F) };
	final static Color[] colNotSaved = { new Color(1.0F, 0.6F, 0.6F), new Color(1.0F, 0.4F, 0.4F) };
	final static Color[] colNoFile = { new Color(0.6F, 0.5F, 1.0F), new Color(0.2F, 0.3F, 1.0F) };

	// sketch indices
	int isketchb;
	int isketche; // last element in list.

	// what's selected.
	int activesketchindex;
	int activetxt; // FileAbstraction.FA_FILE_SVX, etc

    JTree tftree = new JTree(); 
	DefaultMutableTreeNode dmroot = new DefaultMutableTreeNode("root");
	DefaultTreeModel dmtreemod = new DefaultTreeModel(dmroot);

	DefaultMutableTreeNodeFile dmsymbols = new DefaultMutableTreeNodeFile(FileAbstraction.currentSymbols);

	/////////////////////////////////////////////
	void AddTreeDirectory(FileAbstraction td)
	{
    	DefaultMutableTreeNodeFile dmtd = new DefaultMutableTreeNodeFile(td);
		dmroot.add(dmtd); 
		System.out.println("Addtreedirectory " + dmtd.getPath()); 
        dmtreemod.reload(dmroot); 
        LoadDirNode(dmtd); 
    }


	/////////////////////////////////////////////
    void LoadDirNode(DefaultMutableTreeNodeFile dmtf)
    {
		//tunneldirectory.FindFilesOfDirectory(ftsketches, allfontcolours); 
        try
        {
        List<FileAbstraction> fod = dmtf.fa.GetDirContents();
        System.out.println("loaddirnode " + fod.size()); 
        for (FileAbstraction tfile : fod)
        {
        	DefaultMutableTreeNodeFile dmf = new DefaultMutableTreeNodeFile(tfile);
    		dmtf.add(dmf); 
        }
        //dmtf.bdirnodeloaded = true; ; 
        dmtreemod.reload(dmtf); 
        }
        catch (IOException e)
        { TN.emitWarning(e.toString()); }
    }

	/////////////////////////////////////////////
    MouseListener treeml = new MouseAdapter() 
    {
        public void mousePressed(MouseEvent e) 
        {
            int selRow = tftree.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = tftree.getPathForLocation(e.getX(), e.getY());
            if (selRow != -1) 
            {
                DefaultMutableTreeNodeFile dmtf = (DefaultMutableTreeNodeFile)selPath.getLastPathComponent(); 
                System.out.println(dmtf.fa.getAbsolutePath() + "  " + e.getClickCount()); 
//                if(e.getClickCount() == 1) 
//                    SingleClick(selPath);
                if ((e.getClickCount() == 2) && !dmtf.bdirnodeloaded)
                    LoadDirNode(dmtf);
            }
        }
    };

	/////////////////////////////////////////////
	TunnelFileList(MainBox lmainbox)
	{
        super(new BorderLayout());
   		mainbox = lmainbox;

		tftree.setRootVisible(false);
		tftree.setShowsRootHandles(true);
		tftree.setEditable(true); 
		tftree.setExpandsSelectedPaths(true); 
		tftree.addTreeSelectionListener(this);
		//tftree.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		dmroot.add(dmsymbols); 
		tftree.setModel(dmtreemod);
        tftree.addMouseListener(treeml);


		tflistmodel = new DefaultListModel();
		tflist = new JList(tflistmodel);
		tflist.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		tflist.setCellRenderer(new ColourCellRenderer());

		tflist.addListSelectionListener(this);
		tflist.addMouseListener(this);

        JSplitPane jsp = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT); 
		JScrollPane jsplist = new JScrollPane(tflist);
		jsp.setRightComponent(jsplist);
		JScrollPane jsptree = new JScrollPane(tftree);
		jsp.setLeftComponent(jsptree);
	    add(jsp, BorderLayout.CENTER); 
        //Create the scroll pane and add the tree to it.
		//setViewportView(tflist);
	}


	/////////////////////////////////////////////
	OneSketch GetSelectedSketchLoad()
	{
		// load the sketch if necessary.  Then import it
		if (activesketchindex == -1)
			return null; 
		OneSketch lselectedsketch = mainbox.GetActiveTunnelSketches().get(activesketchindex); 
		if (!lselectedsketch.bsketchfileloaded)
		{
			mainbox.tunnelloader.LoadSketchFile(lselectedsketch, true);
			tflist.repaint();
		}
		return lselectedsketch;
	}


	/////////////////////////////////////////////
	class ColourCellRenderer extends JLabel implements ListCellRenderer
	{
		// This is the only method defined by ListCellRenderer.
		// We just reconfigure the JLabel each time we're called.
		public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus)
		{
			assert index != -1;  // this is the null setting for the listed indices
			// one of the strings in the list (the other type files)
			Color[] colsch;
			if (value instanceof String)
			{
				colsch = colNotLoaded;
				setText((String)value);
			}
			else if (!((index >= isketchb) && (index < isketche)))
			{
				TN.emitWarning("strange index setting " + index);
				TN.emitMessage("isketchbbee " + isketchb + "  " + isketche);  // uncomment this line elsewhere

				colsch = colNotLoaded;
				setText(value.toString());
			}

			// sketch type
			// we have to dereference from the array rather than use the object here since it may have been loaded
			else
			{
				assert (index >= isketchb) && (index < isketche);
				OneSketch rsketch = mainbox.GetActiveTunnelSketches().get(index - isketchb);
				FileAbstraction skfile = rsketch.sketchfile;

				setText((isSelected ? "--" : "") + "SKETCH: " + skfile.getPath());
				colsch = (!rsketch.bsketchfileloaded ? colNotLoaded : (rsketch.bsketchfilechanged ? colNotSaved : colLoaded));
			}

			setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
			setBackground(colsch[isSelected ? 1 : 0]);

			setOpaque(true);
			return this;
		}
	}

	/////////////////////////////////////////////
    public void valueChanged(TreeSelectionEvent e)
    {
        //System.out.println("hi there" + e); 
    }

        


	/////////////////////////////////////////////
	void RemakeTFList()
	{
		activesketchindex = -1;
		activetxt = FileAbstraction.FA_FILE_UNKNOWN;

		tflistmodel.clear();

		// list of sketches
		if (!mainbox.GetActiveTunnelSketches().isEmpty())
			tflistmodel.addElement(" ---- ");

		isketchb = tflistmodel.getSize();
		for (OneSketch tsketch : mainbox.GetActiveTunnelSketches())
			tflistmodel.addElement(tsketch);
		isketche = tflistmodel.getSize();
	}


	/////////////////////////////////////////////
	public void UpdateSelect(boolean bDoubleClick)
	{
		// work out what it is that's selected.
		int index = tflist.getSelectedIndex();

		activesketchindex = -1;
		if ((index >= isketchb) && (index < isketche))
		{
			activesketchindex = index - isketchb;
			activetxt = FileAbstraction.FA_FILE_XML_SKETCH;
		}

		// spawn off the window.
		if (bDoubleClick)
			mainbox.ViewSketch();
	}

	/////////////////////////////////////////////
	public void valueChanged(ListSelectionEvent e)
	{
		UpdateSelect(false);
	};


 	/////////////////////////////////////////////
	public void mousePressed(MouseEvent e)  {;};
	public void mouseReleased(MouseEvent e)  {;};
	public void mouseEntered(MouseEvent e)  {;};
	public void mouseExited(MouseEvent e)  {;};
	public void mouseClicked(MouseEvent e)
	{
		//int index = tflist.locationToIndex(e.getPoint());
		if (e.getClickCount() == 2)
			UpdateSelect(true);
	}
}

