//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qtimer.h>
#include <QtGui/qdesktopwidget.h>

#include "AppStartUp.h"
#include "Application.h"
#include "viewGl.h"

using namespace std;
int main( int argc, char **argv ) {
  Application tulip( argc, argv );
  viewGl *mainWindow = new viewGl();
  QDesktopWidget desktop;
  QRect screenRect = desktop.availableGeometry();
  if (screenRect.height() > 890) {
    QRect wRect = mainWindow->geometry();
    int delta = (870 - wRect.height())/2;
    wRect.setTop(wRect.top() - delta);
    wRect.setBottom(wRect.bottom() + delta);
    mainWindow->setGeometry(wRect);
  }
  QTimer::singleShot(0, mainWindow, SLOT(startTulip()) );

  return tulip.exec();
}
