//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#include "PluginsManagerDialog.h"
#include "UpdatePlugin.h"

#include <QtGui/QVBoxLayout>
#include <QtGui/QMessageBox>

#include "PluginsManagerMainWindow.h"

using namespace std;

namespace tlp {

  void PluginsManagerDialog::createWidget(PluginsManagerMainWindow *pluginsManager) {
    connect(pluginsManager, SIGNAL(closeSignal()), this, SLOT(close()));
    QVBoxLayout *layout=new QVBoxLayout(this);
    layout->setMargin(0);
    layout->addWidget(pluginsManager);
    QDialog::setLayout(layout);
  }

  PluginsManagerDialog::PluginsManagerDialog(std::vector<LocalPluginInfo> &plugins,QWidget *parent):QDialog(parent){
    PluginsManagerMainWindow *pluginsManager=new PluginsManagerMainWindow(plugins,parent);
    createWidget(pluginsManager);
  }

  PluginsManagerDialog::PluginsManagerDialog(MultiServerManager *msm,QWidget *parent):QDialog(parent){
    PluginsManagerMainWindow *pluginsManager=new PluginsManagerMainWindow(msm,parent);
    createWidget(pluginsManager);
  }

  bool PluginsManagerDialog::pluginUpdatesPending() {
    return UpdatePlugin::pluginUpdatesPending();
  }
}
