//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef CONVOLUTIONCLUSTERINGSETUP_H
#define CONVOLUTIONCLUSTERINGSETUP_H
#include "ConvolutionClusteringSetupData.h"
#include "ConvolutionClustering.h"

class ConvolutionClusteringSetup
: public QDialog, public Ui::ConvolutionClusteringSetupData { 
    Q_OBJECT

public:
  ConvolutionClusteringSetup(ConvolutionClustering *convolPlugin,QWidget* parent = 0);
    ~ConvolutionClusteringSetup();

  ConvolutionClustering *getPlugin() { return convolPlugin; }
  bool getLogarithmicScale() { return useLogarithmicScale; }
  void abort() { reject(); }

public slots:
  void update();
  void setlog(bool);
private:
  QWidget *histogramWidget;
  ConvolutionClustering *convolPlugin;
  bool useLogarithmicScale;
};

#endif // CONVOLUTIONCLUSTERINGSETUP_H
