//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef Tulip_NODE_H
#define Tulip_NODE_H
#include "tulip/tulipconf.h"
#if (__GNUC__ < 3)
#include <hash_map>
#else
#include <ext/hash_map>
#endif
#include <climits>

/**
 * \addtogroup graphs
 */ 
namespace tlp {

/*@{*/
/// class node
struct node { 
  unsigned int id;
  node():id(UINT_MAX){}
  explicit node(unsigned int j):id(j){}
  bool operator!=(const node n) const {return id!=n.id;}
  bool operator==(const node n) const {return id==n.id;}
  bool isValid() const {return id!=UINT_MAX;}
};
/*@}*/
}

#ifndef DOXYGEN_NOTFOR_DEVEL

namespace stdext {
  template<> struct hash<tlp::node> {
    size_t operator()(const tlp::node n) const {return n.id;}
  };
}

namespace std {
  template<> struct equal_to<tlp::node> {
    size_t operator()(const tlp::node n,const tlp::node n2) const {return n.id==n2.id;}
  };
  template<> struct less<tlp::node>{
    size_t operator()(const tlp::node n,const tlp::node n2) const {return n.id<n2.id;}
  };
}
#endif // DOXYGEN_NOTFOR_DEVEL

#endif
