//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
//@TLPGEOLICENCE#

#ifndef _TLP_GEO_ARRAY_H
#define _TLP_GEO_ARRAY_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <cassert>
#include <iostream>
#include <tulip/tulipconf.h>

namespace tlp {
  /**
   * \addtogroup basic
   */ 
  /*@{*/
  /**
   * \brief class for array encapsulation
   *
   * Enables to create an Array of Obj with a
   * limited size. Out of bound accesses are only checked
   * in debug mode.
   * 
   * \author : David Auber auber@tulip-software.org
   * \version 0.0.1 24/01/2003 
   */
  template <typename Obj,unsigned int SIZE>
  struct Array {
    Obj array[SIZE];
    inline Obj  operator[](const unsigned int i) const;
    inline Obj& operator[](const unsigned int i);
  };
  /**
   * Write array in a stream
   */
  template <typename Obj,unsigned int SIZE>
  std::ostream& operator<<(std::ostream &os,const Array<Obj,SIZE> &);
  template <typename Obj,unsigned int SIZE>
  std::istream& operator>>(std::istream &is, Array<Obj,SIZE> &);

  /*@}*/
}

#include "./cxx/Array.cxx"

#endif


