//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#include "tulip/GlBoundingBoxSceneVisitor.h"

#include <iostream>

#include "tulip/GlGraphInputData.h"
#include "tulip/GlSimpleEntity.h"
#include "tulip/GlNode.h"
#include "tulip/GlEdge.h"
#include "tulip/GlLayer.h"
#include "tulip/Camera.h"
#include "tulip/GlTools.h"

using namespace std;

namespace tlp {

  void GlBoundingBoxSceneVisitor::visit(GlSimpleEntity *entity) {
    if(entity->isVisible()) {
      BoundingBox bb=entity->getBoundingBox();
      
      if(bb.isValid && entity->isCheckByBoundingBoxVisitor()) {
	boundingBox.check(bb.first);
	boundingBox.check(bb.second);
      }
    }
  }
  
  void GlBoundingBoxSceneVisitor::visit(GlNode *glNode) {
    BoundingBox bb=glNode->getBoundingBox(inputData);

    boundingBox.check(bb.first);
    boundingBox.check(bb.second);
  }

  void GlBoundingBoxSceneVisitor::visit(GlEdge *glEdge) {
    BoundingBox bb=glEdge->getBoundingBox(inputData);

    boundingBox.check(bb.first);
    boundingBox.check(bb.second);
  }
}
