#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#if (QT_REL == 3)
#include <qevent.h>
#else
#ifdef  _WIN32
// compilation pb workaround
#include <windows.h>
#endif
#include <QtGui/qevent.h>
#include "tulip/Qt3ForTulip.h"
#endif

#include <tulip/SuperGraph.h>
#include <tulip/LayoutProxy.h>
#include <tulip/ColorsProxy.h>
#include <tulip/GlGraphWidget.h>

#include <tulip/MouseAddEdge.h>

using namespace std;
using namespace tlp;

MouseAddEdge::MouseAddEdge():started(false){}

void MouseAddEdge::mPressEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv) {
  ElementType type;
  node tmpNode;
  edge tmpEdge;
  SuperGraph*_superGraph=glGraphWidget->getSuperGraph();
  LayoutProxy* mLayout=_superGraph->getProperty<LayoutProxy>("viewLayout");
  if (qMouseEv->button()==Qt::LeftButton) {
      if (!started) {
	bool result=glGraphWidget->doSelect(qMouseEv->x(), qMouseEv->y(), type, tmpNode, tmpEdge);
	if (result && (type == NODE)) {
	  started=true;
	  source=tmpNode;
	  glGraphWidget->setMouseTracking(true);
	  curPos=startPos=mLayout->getNodeValue(source);
	}
      }
      else {
	bool result = glGraphWidget->doSelect(qMouseEv->x(),qMouseEv->y(),type,tmpNode,tmpEdge);
	if (result && (type == NODE)) {
	  Observable::holdObservers();
	  started=false;
	  glGraphWidget->setMouseTracking(false);
	  edge newEdge = glGraphWidget->getSuperGraph()->addEdge(source, tmpNode);
	  mLayout->setEdgeValue(newEdge, bends);
	  //	  mColors->setEdgeValue(newEdge, ((Application *)qApp)->edgeColor);
	  bends.clear();
	  glGraphWidget->updateGL();
	  Observable::unholdObservers(); 
	}
	else {
	  float x1, y1, z1;
	  x1 = (double) glGraphWidget->width() - (double) qMouseEv->x(); y1 = (double) qMouseEv->y(); z1 = 0;
	  glGraphWidget->screenTo3DWorld(x1, y1, z1);
	  bends.push_back(Coord(x1, y1, z1));
	  glGraphWidget->updateGL();
	}
      }
  }
  if (qMouseEv->button()==Qt::MidButton) {
      bends.clear();
      glGraphWidget->setMouseTracking(false);
      started=false;
      glGraphWidget->updateGL();
    }
  if (qMouseEv->button()==Qt::RightButton){}
}
void MouseAddEdge:: mPaint(GlGraphWidget *glGraphWidget) {
  if (!started) return;
  float color[4];
  color[0]=1; color[1]=0;  color[2]=0;  color[3]=1;
  vector<Coord>::iterator lCoordIt=bends.begin();
  glGraphWidget->makeCurrent();
  glColor4fv(color);
  glBegin(GL_LINE_STRIP);{
    glVertex3f(startPos.getX(),startPos.getY(),startPos.getZ());
    while(lCoordIt!=bends.end()) {
      glVertex3f(lCoordIt->getX(),lCoordIt->getY(),lCoordIt->getZ());
      ++lCoordIt;
    }
    glVertex3f(curPos.getX(),curPos.getY(),curPos.getZ());
  }glEnd();
}
void MouseAddEdge:: mReleaseEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv) {}
void MouseAddEdge:: mMoveEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv) {
  if (!started) return;
  float x1,y1,z1;
  x1 = (double) glGraphWidget->width() - (double) qMouseEv->x() ;y1 = (double) qMouseEv->y();z1 = 0;
  glGraphWidget->screenTo3DWorld(x1,y1,z1);
  curPos.set(x1,y1,z1);
  glGraphWidget->updateGL();
}
