/*
 * Copyright (C) 2001 Michael Schmitt <schmitt@itm.mu-luebeck.de>
 *
 *    Institute for Telematics,
 *    Medical University of Luebeck,
 *    Ratzeburger Allee 160,
 *    23538 Luebeck,
 *    Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef INC_EnvAST_hpp__
#define INC_EnvAST_hpp__

#include <map>
#ifndef INC_InfoAST_hpp__
#include "InfoAST.hpp"
#endif

#ifndef INC_ASTFactory_hpp__
#include "antlr/ASTFactory.hpp"
#endif

ANTLR_BEGIN_NAMESPACE(antlr)

typedef RefCount< ANTLR_USE_NAMESPACE(std)string > RefString;

class EnvAST;

typedef ASTRefCount< EnvAST >   RefEnvAST;

class EnvAST : public InfoAST
{
  private:
  
    RefEnvAST  parentEnv;
    
  public:
  
    EnvAST();
    EnvAST( RefToken t );
    
    void setParentEnv(RefEnvAST parent);
    RefEnvAST getParentEnv() const;
    
    void addASTList(int length, ASTFactory *factory, ...);

    static void addASTList(RefAST ast, int length, ASTFactory *factory, ...);

		static RefAST factory();
};



ANTLR_END_NAMESPACE

#endif // INC_EnvAST_hpp__
