/*
 * @(#)util/MidiScheduler.h 3.00 2 August 2000
 *
 * Copyright (c) 2000 Pete Goodliffe (pete.goodliffe@pace.co.uk)
 *
 * This file is part of TSE3 - the Trax Sequencer Engine version 3.00.
 *
 * This library is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef TSE3_UTIL_MIDISCHEDULER_H
#define TSE3_UTIL_MIDISCHEDULER_H

#include "tse3/MidiScheduler.h"

#include <iostream>
#include <cstddef>

namespace TSE3
{
    namespace Util
    {
        /**
         * This is a very simple example @ref TSE3::MidiScheduler
         * implementation that merely produces diagnostic output to a given
         * ostream.
         *
         * @short   Diagnostic ostream MidiScheduler implementation
         * @author  Pete Goodliffe
         * @version 3.00
         * @see     MidiScheduler
         * @see     MidiSchedulerFactory
         */
        class StreamMidiScheduler : public MidiScheduler
        {
            public:

                StreamMidiScheduler(std::ostream &stream = std::cout);
                virtual ~StreamMidiScheduler();

                /**
                 * @reimplemented
                 */
                virtual const char *implementationName();

                /**
                 * @reimplemented
                 */
                virtual size_t ports() const;

                /**
                 * @reimplemented
                 */
                virtual const char *portName(size_t port) const;

                /**
                 * @reimplemented
                 */
                virtual const char *portType(size_t port) const;

                /**
                 * @reimplemented
                 */
                virtual bool portReadable(size_t port) const;

                /**
                 * @reimplemented
                 */
                virtual bool portWriteable(size_t port) const;

                /**
                 * @reimplemented
                 */
                virtual void tx(MidiCommand mc);

                /**
                 * @reimplemented
                 */
                virtual void start(Clock startTime);

                /**
                 * @reimplemented
                 */
                virtual void stop(Clock stopTime);

                /**
                 * @reimplemented
                 */
                virtual void moveTo(Clock moveTime, Clock newTime);

                /**
                 * @reimplemented
                 */
                virtual Clock clock();

                /**
                 * @reimplemented
                 */
                virtual int msecs();

                /**
                 * @reimplemented
                 */
                virtual void setTempo(int newTempo, Clock changeTime);

                /**
                 * @reimplemented
                 */
                virtual bool eventWaiting();

                /**
                 * @reimplemented
                 */
                virtual MidiEvent rx();

                /**
                 * @reimplemented
                 */
                virtual void tx(const MidiEvent event);

                /**
                 * @reimplemented
                 */
                virtual void txSysEx(const unsigned char *data, size_t size);

            private:

                StreamMidiScheduler &operator=(const StreamMidiScheduler &);
                StreamMidiScheduler(const StreamMidiScheduler &);
                void outClock(Clock c);
                void outMidiCommand(MidiCommand mc);
                std::ostream &out;
        };

        /**
         * If a MidiScheduler cannot be made for a given platform then this is
         * a placeholder 'null' implementation that does absolutely nothing.
         *
         * @short   Null MidiScheduler implementation (does nothing!)
         * @author  Pete Goodliffe
         * @version 3.00
         * @see     MidiScheduler
         * @see     MidiSchedulerFactory
         */
        class NullMidiScheduler : public MidiScheduler
        {
            public:

                NullMidiScheduler();
                virtual ~NullMidiScheduler();

                /**
                 * @reimplemented
                 */
                virtual const char *implementationName();

                /**
                 * @reimplemented
                 */
                virtual size_t ports() const;

                /**
                 * @reimplemented
                 */
                virtual const char *portName(size_t port) const;

                /**
                 * @reimplemented
                 */
                virtual const char *portType(size_t port) const;

                /**
                 * @reimplemented
                 */
                virtual bool portReadable(size_t port) const;

                /**
                 * @reimplemented
                 */
                virtual bool portWriteable(size_t port) const;

                /**
                 * @reimplemented
                 */
                virtual void tx(MidiCommand mc);

                /**
                 * @reimplemented
                 */
                virtual void start(Clock startTime);

                /**
                 * @reimplemented
                 */
                virtual void stop(Clock stopTime);

                /**
                 * @reimplemented
                 */
                virtual void moveTo(Clock moveTime, Clock newTime);

                /**
                 * @reimplemented
                 */
                virtual Clock clock();

                /**
                 * @reimplemented
                 */
                virtual int msecs();

                /**
                 * @reimplemented
                 */
                virtual void setTempo(int newTempo, Clock changeTime);

                /**
                 * @reimplemented
                 */
                virtual bool eventWaiting();

                /**
                 * @reimplemented
                 */
                virtual MidiEvent rx();

                /**
                 * @reimplemented
                 */
                virtual void tx(MidiEvent event);

                /**
                 * @reimplemented
                 */
                virtual void txSysEx(const unsigned char *data, size_t size);

            private:

                NullMidiScheduler &operator=(const NullMidiScheduler &);
                NullMidiScheduler(const NullMidiScheduler &);
        };
    }
}

#endif
