/*
 * @(#)plt/Arts.h 3.00 12 October 2000
 *
 * Copyright (c) 2000 Pete Goodliffe (pete.goodliffe@pace.co.uk)
 *
 * This file is part of TSE3 - the Trax Sequencer Engine version 3.00.
 *
 * This library is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef TSE3_PLT_ARTS_H
#define TSE3_PLT_ARTS_H

#include "tse3/MidiScheduler.h"

namespace TSE3
{
    namespace Plt
    {
        /**
         * This is the Arts @ref MidiScheduler implementation.
         *
         * @short   Arts MidiScheduler implementation
         * @author  Pete Goodliffe
         * @version 0.00
         * @see     MidiScheduler
         * @see     ArtsMidiSchedulerFactory
         */
        class ArtsMidiScheduler : public MidiScheduler
        {
            public:

                /**
                 * @throws TSE3::MidiSchedulerError
                 */
                ArtsMidiScheduler();
                virtual ~ArtsMidiScheduler();

                /**
                 * @reimplemented
                 */
                virtual const char *implementationName();

                /**
                 * @reimplemented
                 */
                virtual size_t ports() const;

                /**
                 * @reimplemented
                 */
                virtual const char *portName(size_t port) const;

                /**
                 * @reimplemented
                 */
                virtual const char *portType(size_t port) const;

                /**
                 * @reimplemented
                 */
                virtual bool portReadable(size_t port) const;

                /**
                 * @reimplemented
                 */
                virtual bool portWriteable(size_t port) const;

                /**
                 * @reimplemented
                 */
                virtual void tx(MidiCommand mc);

                /**
                 * @reimplemented
                 */
                virtual void start(Clock startTime);

                /**
                 * @reimplemented
                 */
                virtual void stop(Clock stopTime);

                /**
                 * @reimplemented
                 */
                virtual void moveTo(Clock moveTime, Clock newTime);

                /**
                 * @reimplemented
                 */
                virtual Clock clock();

                /**
                 * @reimplemented
                 */
                virtual int msecs();

                /**
                 * @reimplemented
                 */
                virtual void setTempo(int newTempo, Clock changeTime);

                /**
                 * @reimplemented
                 */
                virtual bool eventWaiting();

                /**
                 * @reimplemented
                 */
                virtual MidiEvent rx();

                /**
                 * @reimplemented
                 */
                virtual void tx(MidiEvent event);

                /**
                 * @reimplemented
                 */
                virtual void txSysEx(const unsigned char *data, size_t size);

            private:

                ArtsMidiScheduler(const ArtsMidiScheduler &);
                ArtsMidiScheduler &operator=(const ArtsMidiScheduler &);

                size_t           noports;
                class ArtsImpl  *pimpl;
        };

        /**
         * This is the Arts version of the @ref MidiSchedulerFactory. It makes
         * appropriate decisions to deliver you a @ref MidiScheduler that will
         * run under Arts.
         *
         * @short   Arts MidiScheduler class factory
         * @author  Pete Goodliffe
         * @version 1.00
         */
        class ArtsMidiSchedulerFactory : public MidiSchedulerFactory
        {
            public:

                ArtsMidiSchedulerFactory();
                virtual ~ArtsMidiSchedulerFactory();

                /**
                 * @reimplemented
                 */
                virtual ArtsMidiScheduler *createScheduler();

            private:
        };
    }
}

#endif
