/* hci.h -- Hardware Configuration Interface
 *
 * Copyright (c) 1998,1999  Jonathan A. Buzzard (jab@hex.prestel.co.uk)
 *
 * WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING
 *
 *   This code is covered by the GNU GPL and you are free to make any
 *   changes you wish to it under the terms of the license. However the
 *   code has the potential to render your computer and/or someone else's
 *   unuseable. Unless you truely understand what is going on, I urge you
 *   not to make any modifications and use it as it stands.
 *
 * $Log: hci.h,v $
 * Revision 1.4  2002/01/23 19:50:26  schwitrs
 * replaced HciRegisters w/ SMMRegisters
 * added HCI_POWER_UP (from toshiba hibernation file docs)
 *
 * Revision 1.3  2002/01/19 23:00:56  schwitrs
 * added HCI_TVOUT
 *
 * Revision 1.2  2001/05/14 16:39:51  schwitrs
 * changed HCI codes for video out mode
 *
 * Revision 1.1  2000/02/03 02:49:03  schwitrs
 * Initial revision
 *
 * Revision 1.1  1999/03/11 20:29:11  jab
 * Initial revision
 *
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef HCI_H
#define HCI_H

#ifdef __cplusplus
extern "C" {
#endif

#include "smm.h"

#ifdef NOTUSED
typedef struct {
	  unsigned long ax;
	  unsigned long bx;
	  unsigned long cx;
	  unsigned long dx;
} HciRegisters;
#endif /*NOTUSED*/

enum {
	HCI_GET             = 0xfeC0,
	HCI_SET             = 0xffC0
};


enum {
	HCI_BACKLIGHT       = 0x0002,
	HCI_AC_ADAPTOR      = 0x0003,
	HCI_FAN             = 0x0004,
	HCI_SOFTWARE_SUSPEND = 0x0010,
	HCI_FLAT_PANEL       = 0x0011,
	HCI_SELECT_STATUS    = 0x0014,
	HCI_SYSTEM_EVENT     = 0x0016,
	HCI_FIR_STATUS       = 0x001b,
	HCI_VIDEO_OUT        = 0x001c,
	HCI_HOTKEY_EVENT     = 0x001e,
	HCI_UNUSED_MEMORY    = 0x0021,
	HCI_LOCK_STATUS      = 0x0022,
	HCI_BOOT_DEVICE      = 0x0026,
	HCI_OWNERSTRING      = 0x0029,
	HCI_HIBERNATION_INFO = 0x002d,
	HCI_HIBERNATION_LBA  = 0x002e,
	HCI_POWER_UP         = 0x0048
};


/*
 * the different states the various modes can be set to
 */

enum {
	HCI_DISABLE         = 0x0000,
	HCI_ENABLE          = 0x0001
};

enum {
	HCI_640_480         = 0x00,
	HCI_800_600         = 0x01,
	HCI_1024_768        = 0x02,
	HCI_1024_600        = 0x03,
	HCI_800_480         = 0x04
};

enum {
	HCI_STN_MONO        = 0x00,
	HCI_STN_COLOUR      = 0x01,
	HCI_9BIT_TFT        = 0x02,
	HCI_12BIT_TFT       = 0x03,
	HCI_18BIT_TFT       = 0x04,
	HCI_24BIT_TFT       = 0x05	
};

//enum {
//	  HCI_INTERNAL        = 0x0000,
//	  HCI_EXTERNAL        = 0x0001,
//	  HCI_SIMULTANEOUS    = 0x0002
//};
enum {
	  HCI_INTERNAL        = 0x0101,
	  HCI_EXTERNAL        = 0x0102,
	  HCI_SIMULTANEOUS    = 0x0103,
	  HCI_TVOUT           = 0x0104
};

enum {
	HCI_BIOS_SIZE       = 0x0000,
	HCI_MEMORY_SIZE     = 0x0001,
	HCI_VRAM_SIZE       = 0x0002
};

enum {
	HCI_BUILT_IN        = 0x0000,
	HCI_SELECT_INT      = 0x0001,
	HCI_SELECT_DOCK     = 0x0002,
	HCI_5INCH_DOCK      = 0x0003
};

enum {
	HCI_LOCKED          = 0x0000,
	HCI_UNLOCKED        = 0x0001
};

enum {
	HCI_NOTHING         = 0x0000,
	HCI_FLOPPY          = 0x0001,
	HCI_ATAPI           = 0x0002,
	HCI_IDE             = 0x0003,
	HCI_BATTERY         = 0x0004
};

/*
 * HCI error codes
 */
enum {
	HCI_SUCCESS         = 0x00,
	HCI_FAILURE         = 0x01,
	HCI_NOT_SUPPORTED   = 0x80,
	HCI_INPUT_ERROR     = 0x83,
	HCI_WRITE_PROTECTED = 0x84,
	HCI_FIFO_EMPTY      = 0x8c
};




/*
 * function prototypes
 */
int HciGet(unsigned short mode, unsigned short *status);
int HciSet(unsigned short mode, unsigned short status);
int HciFunction(SMMRegisters *reg);
int HciGetBiosVersion(void);
int HciGetMachineID(int *id);
int HciFnStatus(void);


#ifdef __cplusplus
}
#endif

#endif
