namespace eval placard {
    variable placard

    # Define the placard data structure and option database entries.
    if {$tkWorld(ostype) == "windows"} {
	set placard(font.title) {helvetica 12 bold}
	set placard(font.message) {helvetica 10}
	set placard(font.info) {helvetica 10 italic}
	option add *Placard.borderwidth 1
	option add *Placard.relief flat
    } else {
	set placard(font.title) {helvetica 14 bold}
	set placard(font.message) {helvetica 12}
	set placard(font.info) {helvetica 12 italic}
	option add *Placard.borderwidth 2
	option add *Placard.relief raised
    }
}

# placard::create --
#
#   Display a nice popup when tkWorld is started, then start
#   the application
#
# Args
#
#   None
#
# Returns
#
#   None

proc placard::create { } {
    global tkWorld
    variable placard

    # Withdraw the parent window of the application and build it in
    # the background.
    wm withdraw .
    toplevel .placard -class Placard
    wm overrideredirect .placard 1

    # Determine where to place the message popup.
    after idle {
	update idletasks

	set xmax [winfo screenwidth .placard]
	set ymax [winfo screenheight .placard]
	
	set x0 [expr ($xmax - [winfo reqwidth .placard])/2]
	set y0 [expr ($ymax - [winfo reqheight .placard])/2]

	wm geometry .placard "+$x0+$y0"
    }

    # Create the elements of the placard.
    set img [image create photo \
	    -file [file join $tkWorld(image_dir) tkWorld.gif]]

    label .placard.icon \
	    -image $img
    label .placard.title \
	    -text "Welcome to tkWorld!" \
	    -foreground red \
	    -font $placard(font.title)
    label .placard.message \
	    -text "Loading version $tkWorld(version)" \
	    -font $placard(font.message)
    label .placard.info \
	    -text "$tkWorld(copyright)" \
	    -font $placard(font.info)

    # Build the placard with the tkWorld icon.
    grid .placard.icon \
	    -row 0 \
	    -column 0 \
	    -rowspan 4 \
	    -padx 5 \
	    -pady 5
    grid .placard.title \
	    -row 0 \
	    -column 1 \
	    -padx 5 \
	    -sticky ew
    grid .placard.message \
	    -row 1 \
	    -column 1 \
	    -padx 5 \
	    -sticky ew
    grid .placard.info \
	    -row 2 \
	    -column 1 \
	    -padx 5 \
	    -sticky ew

    # Change the message on the placard
    after 1000 {
	update idletasks
	.placard.message configure \
		-text "Loading the registry"
    }

    # Now that the placard is being viewed, build the app in
    # the background.
    update
    gui::create

    # Update one last time so that the app does not flicker and
    # remove the placard.
    update
    after 2000 {
	update idletasks
	destroy .placard
	wm deiconify .
    }
}

