!
!       Dynamic Fibonacci Sequence Function
!       Author: Dave Osborn
!       Remarks: Program finds the Nth Fibonacci number in the sequence
!                either by looking up the value in a table or by direct
!                computation. If a computation is performed then the
!                value is stored in a table for future reference.
!
	.seg    "text"
	.global main

main:
	mov     0x5,%o0                ! Load N
	call    dfib,1                ! dfib(N)
	nop                            ! Fill delay slot

exit:
	ret                            ! Finished
	nop                            ! Fill delay slot
	
!
!       Dynamic Fibonacci Function
!       Register Usage:
!         %i0      :    Number of Ith sequence we are to find
!         %l0      :    %i0 - 1; Used for finding the offset into Array
!         %l1      :    Local Temporary
!         %o0      :    Copy of %i0, used to return value.
!         %o1      :    Base Address of Array
!         %o2      :    Offset into Array for element N
!         %o3      :    Value stored in Array[N]
!
dfib:
	save    %sp,-96,%sp            ! Preserve Register Windows
	mov     %i0,%l0                ! Load N for manipulation
	sub     %l0,0x1,%l0            ! Array index is really an offset
				       ! from 0.
	set     Array,%o1              ! Load address of Array
	sll     %l0,0x2,%o2            ! Find Offset into Array
	ld      [%o1+%o2],%o3          ! Load Value at Array[%o2]
	tst     %o3                    ! Array[%o2] == 0??
	be      fib                   ! Yes, Compute Fibonacci
	nop                            ! Fill Delay Slot

	! Array[%o2] = a computed value, return the value in %o3
	mov     %o3,%o0
	b       finis
	nop

fib:
	cmp     %i0,0x2                ! N <= 2?
	bg      recurse               ! Nope, recurse
	nop                            ! Fill delay slot
	mov     0x1,%o0                ! fib = 1
	b       finis                 ! We're finished
	nop                            ! fill delay slot

recurse:
	sub     %i0,0x2,%o0            ! N - 2
	call    dfib,1                ! dfib(N - 2)
	nop                            ! Fill Delay Slot
	mov     %o0,%l1                ! Save Result for later
	sub     %i0,0x1,%o0            ! N - 1
	call    dfib,1                ! dfib(N - 1)
	nop                            ! Fill Delay Slot
	add     %o0,%l1,%o0            ! dfib(N - 1) + dfib(N - 2)
	st      %o0,[%o1+%o2]          ! Array[%o2] = %o0

finis:
	mov     %o0,%i0                ! return value
	ret
	restore
!
!    Initialized Array of Data. Apparently as does not have a simple
!    directive to setup a block of initialized memory so we have to
!    specify our initialized data.
!
	.seg    "data"
	.align  4
Array:
	.word   0x1,0x1,0x0,0x0,0x0        !  Array[5] = {1, 1, 0, 0, 0}
