#!/bin/sh
#-*-tcl-*-
# the next line restarts using wish \
if [ -z "$DISPLAY" ]; then exec tclsh "$0" -- ${1+"$@"}; else exec wish "$0" -- ${1+"$@"}; fi

#
# $Id: doinstall.tcl,v 1.9 2002/01/23 17:18:03 dorothyr Exp $
#
# Usage: doinstall.tcl [-nox] [-finaldir user-destination] [destination]
#
# For a non-interactive installation which doesn't require an X server, do
##  doinstall.tcl -nox /usr/local
#
# If you're making a debian-style distro, you can use -finaldir to specify where the
# tkcvs # libraries will ultimately be installed on the user's system and the final
# argument to specify the location of your package.  For example, if your package is
# /src/tkcvs-7.x but its destination is /opt/lib/tkcvs, the command would be
##  doinstall.tcl -nox -finaldir /opt/lib /src/tkcvs-7.x

proc set_paths {INSTALLROOT} {
  global tcl_platform
  global LIBDIR BINDIR MANDIR
  global FINLIBDIR

  if {$tcl_platform(platform) == "windows"} {
    set BINDIR [file join $INSTALLROOT bin]
    set LIBDIR [file join $INSTALLROOT lib]
    set MANDIR ""
  } else {
    set BINDIR [file join $INSTALLROOT bin]
    set LIBDIR [file join $INSTALLROOT lib]
    set MANDIR [file join $INSTALLROOT man man1]
  }
}

proc show_paths {INSTALLROOT} {
  global tcl_platform
  global TKCVS TKDIFF
  global LIBDIR BINDIR MANDIR

  set_paths $INSTALLROOT

  set msg(1) [file join $BINDIR $TKCVS]
  set msg(2) [file join $BINDIR $TKDIFF]
  set msg(3) [file join $LIBDIR tkcvs *.tcl]
  set msg(4) [file join $LIBDIR tkcvs bitmaps *.gif,xbm]
  if {$tcl_platform(platform) == "unix"} {
     set msg(5) [file join $MANDIR tkcvs.1]
  }
  foreach m [lsort [array names msg]] {
    if {[winfo exists .messages.$m]} {
      destroy .messages.$m
    }
    global var$m
    set var$m $msg($m)
    label .messages.$m -text $msg($m) -justify left -textvariable var$m
    pack .messages.$m -side top -anchor w
  }
}

proc doinstall { INSTALLROOT } {
  global tcl_platform
  global TKCVS TKDIFF
  global LIBDIR BINDIR MANDIR
  global FINLIBDIR
  global X

  set_paths $INSTALLROOT

  # Some directories we have to create.
  set TCDIR [file join $LIBDIR tkcvs]
  set GFDIR [file join $LIBDIR tkcvs bitmaps]
  file mkdir $INSTALLROOT
  foreach dir [concat $BINDIR $GFDIR $TCDIR] {
    file mkdir $dir
  }

  if {$FINLIBDIR == ""} {
    set FINLIBDIR $LIBDIR
  }
  #puts "LIBDIR $LIBDIR FINLIBDIR $FINLIBDIR"
  set destfile [file join $BINDIR $TKCVS]
  puts "Installing $TKCVS in $BINDIR"
  set blank [open [file join tkcvs tkcvs.blank] "r"]
  set filled [open $destfile "w"]
  while {! [eof $blank]} {
    gets $blank line
    regsub -all {_TCDIR_} $line "$FINLIBDIR" line
    puts $filled $line
  }
  close $blank
  close $filled
  puts "Installing $TKDIFF in $BINDIR"
  file copy -force [file join tkdiff tkdiff] [file join $BINDIR $TKDIFF]

  if {$tcl_platform(platform) == "unix"} {
    file attributes $destfile -permissions 0755
    file attributes [file join $BINDIR $TKDIFF] -permissions 0755
    file mkdir $MANDIR
    puts "Installing manpage tkcvs.1 in $MANDIR"
    file copy -force [file join tkcvs tkcvs.1] $MANDIR
  }

  puts "Installing tcl files in $TCDIR"
  cd tkcvs
  foreach tclfile [glob *.tcl tclIndex] {
    puts "  $tclfile"
    file copy -force $tclfile $TCDIR
  }

  puts "Installing icons in $GFDIR"
  cd [file join .. bitmaps]
  foreach pixfile [glob *.gif *.xbm] {
    puts "  $pixfile"
    file copy -force $pixfile $GFDIR
  }
  cd ..
  puts "Finished!"

  if {$X} {
    destroy .bottom.do
    destroy .bottom.not
    button .bottom.done -text "Finished!" -command {destroy .}
    pack .bottom.done
  }
}

################################################################################

set usage "Usage: doinstall.tcl \[-nox\] \[-finallib user-destination\] \[destination\]"
set X 1
puts "[info nameofexecutable]"
if {[string match "*tclsh" [info nameofexecutable]]} {
  set X 0
}

# Check Tcl/TK version
if {$tcl_version < 8.1} {
   tk_dialog .wrongversion "Tcl/Tk too old" \
   "TkCVS requires Tcl/Tk 8.1 or better!" \
   error 0 {Bye Bye}
   exit 1
}

# Some rational and reasonable defaults.
if {$tcl_platform(platform) == "windows"} {
  set INSTALLROOT "C:\\"
  set TKCVS "tkcvs.tcl"
  set TKDIFF "tkdiff.tcl"
} else {
  set INSTALLROOT [file join  /usr local]
  set TKCVS "tkcvs"
  set TKDIFF "tkdiff"
}
set FINLIBDIR ""

# See if the user changed them with command-line args
for {set i 0} {$i < [llength $argv]} {incr i} {
  set arg [lindex $argv $i]
  switch -- $arg {
    -nox { set X 0 }
    --help { puts "$usage"; exit }
    -h { puts "$usage"; exit }
    -finallib {
      incr i
      set FINLIBDIR [lindex $argv $i]
      if {[string length $FINLIBDIR] == 0} {
        puts stderr $usage
        exit 1
      }
    }
    default { 
      set INSTALLROOT $arg
    }
  }
}
    
if {$X} {
  frame .title
  label .title.lbl -text "TkCVS Installer" -font {Helvetica -14 bold}
  pack .title -side top
  pack .title.lbl -side top
  frame .entry
  label .entry.instlbl -text "Installation Root"
  entry .entry.instent -textvariable INSTALLROOT
  bind .entry.instent <Return> {show_paths $INSTALLROOT}
  bind .entry.instent <KeyRelease> {show_paths $INSTALLROOT}
  pack .entry -side top -pady 10
  pack .entry.instlbl -side left
  pack .entry.instent -side left
  
  frame .messages -relief groove -bd 2
  pack .messages -side top -expand y -fill x
  label .messages.adv -text "These files will be installed:"
  pack .messages.adv -side top
  show_paths $INSTALLROOT

  frame .bottom
  button .bottom.do -text "Install" -command {doinstall $INSTALLROOT}
  button .bottom.not -text "Cancel" -command {destroy .}
  pack .bottom -side top
  pack .bottom.do -side left
  pack .bottom.not -side left
} else {
  doinstall $INSTALLROOT
  exit
}

