# $Id: si.tcl,v 1.4 2004/07/15 21:56:10 aleksey Exp $

# File transfer via SI

namespace eval si {
    set winid 0
    set id 0
    set chunk_size 4096

    variable options

    custom::defgroup SI \
	[::msgcat::mc "Stream initiation options."] \
	-group FileTransfer

    custom::defvar options(enable) 1 \
	[::msgcat::mc "Enable SI transport for outgoing file transfers."] \
	-group SI -type boolean
}

set ::NS(file-transfer) http://jabber.org/protocol/si/profile/file-transfer

proc si::send_file_dialog {user args} {
    variable winid

    foreach {opt val} $args {
	switch -- $opt {
	    -connection { set connid $val }
	}
    }
    if {![info exists connid]} {
	set connid [jlib::route $user]
    }

    while {[winfo exists .sfd$winid]} {
	incr winid
    }
    set w .sfd$winid

    variable filename$winid

    Dialog $w -title [format [::msgcat::mc "Send file to %s"] $user] \
	-separator 1 -anchor e -modal none \
	-default 0 -cancel 1

    set f [$w getframe]

    label $f.lfile -text [::msgcat::mc "File to send:"]
    entry $f.file -textvariable [list [namespace current]::filename$winid]
    button $f.browsefile -text [::msgcat::mc "Browse..."] \
	-command [list [namespace current]::set_send_file_name $winid]

    label $f.ldesc -text [::msgcat::mc "Description:"]
    text $f.desc -width 50 -height 5

    ProgressBar $f.pb -variable [namespace current]::progress$f.pb
    variable progress$f.pb 0

    grid $f.lfile      -row 0 -column 0 -sticky e
    grid $f.file       -row 0 -column 1 -sticky ew
    grid $f.browsefile -row 0 -column 2 -sticky ew
    
    grid $f.ldesc -row 1 -column 0 -sticky en
    grid $f.desc  -row 1 -column 1 -sticky ewns -columnspan 2 -pady 1m

    grid $f.pb -row 2 -column 0 -sticky ew -columnspan 3 -pady 2m

    grid columnconfigure $f 1 -weight 1
    grid rowconfigure $f 1 -weight 1

    $w add -text [::msgcat::mc "Send"] \
	-command [list [namespace current]::send_file_start \
		      $winid $f $user \
		      -connection $connid]
    $w add -text [::msgcat::mc "Cancel"] -command [list destroy $w]

    incr winid
    $w draw $f.file
}

proc si::set_send_file_name {winid} {
    variable filename$winid

    set file [tk_getOpenFile]
    if {$file != ""} {
	set filename$winid $file
    }
}

proc si::send_file_start {winid f user args} {

    .sfd$winid itemconfigure 0 -state disabled

    foreach {opt val} $args {
	switch -- $opt {
	    -connection { set connid $val }
	}
    }
    if {![info exists connid]} {
	set connid [jlib::route $user]
    }

    set filename [$f.file get]
    set desc [$f.desc get 0.0 "end -1c"]

    if {![file isfile $filename]} {
	MessageDlg .filenofound$winid -aspect 50000 -icon error \
	    -message [format [::msgcat::mc \
				  "File not found or not regular file: %s"] \
			  $filename] \
	    -type user \
	    -buttons ok -default 0 -cancel 0
	.sfd$winid itemconfigure 0 -state normal
	return
    }

    set fsize [file size $filename]
    $f.pb configure -maximum $fsize
    .sfd$winid itemconfigure 0 -state disabled
    #destroy .sfd$winid

    debugmsg filetransfer "SENDFILE: $filename; $desc"

    send_file_setup_connection $connid $user $filename $desc $winid
    #bind .sfd$winid <Destroy> [list ft::send_file_cancel $winid $servsock]
}


proc si::send_file_setup_connection {connid user filename desc winid} {
    variable files
    variable chunk_size

    set id [random 1000000000]
    set name [file tail $filename]
    set size [file size $filename]

    set files(filename,$id) $filename
    set files(w,$id) .sfd$winid

    set profile [jlib::wrapper:createtag file \
		     -vars [list xmlns $::NS(file-transfer) \
				id $id \
				name $name \
				size $size] \
		     -subtags [list [jlib::wrapper:createtag desc \
					 -chdata $desc]]]

    set res [si::connect $connid $user $id application/octet-stream \
		 $::NS(file-transfer) $profile]

    if {![lindex $res 0]} {
	MessageDlg .auth_err -aspect 50000 -icon error \
	    -message [format [::msgcat::mc "Request failed: %s"] \
			  [lindex $res 1]] -type user \
	    -buttons ok -default 0 -cancel 0
	return
    }

    set w $files(w,$id)

    if {![winfo exists $w]} {
	si::close $id
	return
    }

    bind $w <Destroy> [list [namespace current]::send_file_close $id]

    set fd [open $filename]
    fconfigure $fd -translation binary

    set files(rfd,$id) $fd

    set pb [$files(w,$id) getframe].pb
    variable progress$pb
    $pb configure -maximum [file size $filename]

    #set chunk [read $fd]
    set_status [::msgcat::mc "Transferring..."]

    set chunk [read $fd $chunk_size]
    #catch {
	while {$chunk != ""} {
	    si::send_data $id $chunk
	    set progress$pb [tell $fd]
	    #after 1000
	    update idletasks
	    set chunk [read $fd $chunk_size]
	}
    #}

    catch { close $fd }
    catch { destroy $w }

    si::close $id
}

proc si::send_file_close {id} {
    variable files

    catch { close $files(rfd,$id) }
    #set w $files(w,$id)
    #si::close $id
    #destroy $w
}

###############################################################################

proc si::recv_file_dialog {from id name size date hash desc} {
    variable winid
    variable files

    set w .rfd$winid

    while {[winfo exists $w]} {
	incr winid
	set w .rfd$winid
    }

    Dialog $w -title [format [::msgcat::mc "Receive file from %s"] $from] \
	-separator 1 -anchor e \
	-modal none -default 0 -cancel 1


    set f [$w getframe]

    label $f.lname -text [::msgcat::mc "Name:"]
    label $f.name -text $name

    label $f.lsize -text [::msgcat::mc "Size:"]
    label $f.size -text $size

    label $f.ldesc -text [::msgcat::mc "Description:"]
    message $f.desc -width 10c -text $desc

    set dir $ft::options(download_dir)
    label $f.lsaveas -text [::msgcat::mc "Save as:"]
    entry $f.saveas -textvariable [namespace current]::saveas$winid
    variable saveas$winid [file join $dir $name]
    button $f.browsefile -text [::msgcat::mc "Browse..."] \
	-command [list [namespace current]::set_receive_file_name $winid $dir $name]

    set pbvar [namespace current]::progress$f.pb
    ProgressBar $f.pb -variable $pbvar
    $f.pb configure -maximum $size
    set $pbvar 0

    grid $f.lname   -row 0 -column 0 -sticky e
    grid $f.name    -row 0 -column 1 -sticky w
    
    grid $f.lsize   -row 1 -column 0 -sticky e
    grid $f.size    -row 1 -column 1 -sticky w
    
    grid $f.ldesc   -row 2 -column 0 -sticky en
    grid $f.desc    -row 2 -column 1 -sticky ewns -columnspan 2 -pady 1m

    grid $f.lsaveas -row 3 -column 0 -sticky e
    grid $f.saveas  -row 3 -column 1 -sticky ew
    grid $f.browsefile  -row 3 -column 2 -sticky ew

    grid $f.pb      -row 4 -column 0 -sticky ew -columnspan 3 -pady 2m

    grid columnconfigure $f 1 -weight 1 -minsize 8c
    grid rowconfigure $f 2 -weight 1
    
    $w add -text [::msgcat::mc "Receive"] -command \
	[list [namespace current]::recv_file_start $winid $pbvar $from $id]
    $w add -text [::msgcat::mc "Cancel"] -command \
	[list [namespace current]::recv_file_cancel $w $id]
    
    incr winid

    $w draw

    vwait [namespace current]::result($id,recv)
    return [set [namespace current]::result($id,recv)]
}

proc si::set_receive_file_name {winid dir fname} {
    variable saveas$winid

    set file [tk_getSaveFile -initialdir $dir -initialfile $fname]
    if {$file != ""} {
	set saveas$winid $file
    }
}

proc si::recv_file_cancel {w id} {
    set [namespace current]::result($id,recv) [list error cancel forbidden]
    destroy $w
}

proc si::recv_file_start {winid pbvar user id} {
    variable saveas$winid
    variable files

    set filename [set saveas$winid]

    .rfd$winid itemconfigure 0 -state disabled
    set $pbvar 0

    set files(filename,$id) $filename

    set fd [open $filename w]
    fconfigure $fd -translation binary

    set files(fd,$id) $fd
    set w .rfd$winid

    si::set_readable_handler \
	$id [list [namespace current]::recv_file_chunk $pbvar]
    si::set_closed_handler \
	$id [list [namespace current]::closed $w]

    set [namespace current]::result($id,recv) {}
}

proc si::recv_file_chunk {pbvar key} {
    variable files

    if {[info exists files(filename,$key)]} {
	set data [si::read_data $key]

	debugmsg filetransfer "RECV into $files(filename,$key) data $data"

	puts -nonewline $files(fd,$key) $data

	incr $pbvar [string bytelength $data]
	debugmsg filetransfer [set $pbvar]
    }

}

proc si::closed {w key} {
    variable files

    if {[info exists files(filename,$key)]} {
	debugmsg filetransfer CLOSE
	catch { close $files(fd,$key) }
	catch { destroy $w }
	unset files(filename,$key)
	set_status [::msgcat::mc "Connection closed"]
    }
}

proc si::si_handler {from id mimetype child} {
    debugmsg filetransfer "SI set: [list $from $child]"

    jlib::wrapper:splitxml $child tag vars isempty chdata children

    if {$tag == "file"} {
	set desc ""
	foreach item $children {
	    jlib::wrapper:splitxml $item tag1 vars1 isempty1 chdata1 children1
	    switch -- $tag1 {
		desc {set desc $chdata1}
	    }
	}

	recv_file_dialog \
	    $from \
	    $id \
	    [jlib::wrapper:getattr $vars name] \
	    [jlib::wrapper:getattr $vars size] \
	    [jlib::wrapper:getattr $vars date] \
	    [jlib::wrapper:getattr $vars hash] \
	    $desc
    } else {
	return [list error modify bad-request]
    }
}

si::register_profile $::NS(file-transfer) [namespace current]::si::si_handler


proc si::add_menu_item {m cascad jid args} {
    variable options

    if {!$options(enable)} return

    if {$cascad} {
	set label [::msgcat::mc "via SI..."]
    } else {
	set label [::msgcat::mc "Send file via SI..."] \
    }
    $m add command -label $label \
        -command [list eval \
		      [list [namespace current]::send_file_dialog $jid] $args]

    hook::unset_flag create_filetransfer_menu_hook transport
}

hook::add create_filetransfer_menu_hook \
    [namespace current]::si::add_menu_item 10

