# $Id: me_command.tcl,v 1.9 2006/01/08 21:52:17 aleksey Exp $

proc handle_me {chatid from type body x} {
    if {[cequal [crange $body 0 3] "/me "] || [cequal $body "/me"]} {
	set body [crange $body 4 end]

	if {[chat::is_our_jid $chatid $from]} {
	    set tag me
	} else {
	    set tag they
	}

	set connid [chat::get_connid $chatid]
	set chatw [chat::chat_win $chatid]
	set nick [chat::get_nick $connid $from $type]
	set cw [chat::winid $chatid]

	$chatw mark set MSGLEFT "end - 1 char"
	$chatw mark gravity MSGLEFT left

	$chatw insert end "* $nick " $tag

	if {[cequal $type groupchat]} {
	    set myjid [chat::our_jid $chatid]
	    set mynick [chat::get_nick $connid $myjid $type]

	    lassign [check_message $mynick $body] mymessage mylist
	    chat::add_emoteiconed_text $chatw $body $tag $mylist
	    if {$mymessage} {
		tab_set_updated $cw 1 mesg_to_user
	    } else {
		tab_set_updated $cw 1 message
	    }
	} else {
	    chat::add_emoteiconed_text $chatw $body $tag
	    tab_set_updated $cw 1 mesg_to_user
	}

        $chatw tag add NICK-$nick MSGLEFT "end - 1 char"

	return stop
    }
}
hook::add draw_message_hook [namespace current]::handle_me 83

proc me_command_comp {chatid compsvar wordstart line} {
    upvar 0 $compsvar comps

    if {!$wordstart} {
	lappend comps {/me }
    }
}

hook::add generate_completions_hook [namespace current]::me_command_comp

