# $Id: plugins.tcl,v 1.10 2006/02/25 19:57:36 aleksey Exp $

namespace eval plugins {}

proc plugins::load {dir args} {
    set dir [fullpath $dir]
    set uplev 0
    foreach {attr val} $args {
	switch -- $attr {
	    -uplevel {set uplev $val}
	}
    }

    foreach file [glob -nocomplain $dir/*.tcl] {
	debugmsg plugins "Loading plugin from $file"
	if {$uplev} {
	    uplevel [list source $file]
	} else {
	    source $file
	}
    }
}

proc plugins::load_dir {plugins_dir} {
    foreach dir [lsort [glob -nocomplain -type d [file join $plugins_dir *]]] {
	set file [file join $dir [file tail $dir].tcl]
	if {[file exists $file]} {
	    debugmsg plugins "Loading plugin from $file"
	    source $file
	} else {
	    debugmsg plugins "Can't load plugin from $file"
	}
    }
}

