# $Id: emoticons.tcl,v 1.15 2005/03/27 20:31:13 aleksey Exp $

namespace eval emoteicons {
    array set emoteicons {}

    variable lasttext ""
    variable lastX
    variable lastY
}

proc emoteicons::add {word image} {
    variable emoteicons
    set emoteicons($word) $image
}

proc emoteicons::get {word} {
    variable emoteicons

    if {[info exists emoteicons($word)]} {
	return $emoteicons($word)
    } else {
	return ""
    }
}

proc emoteicons::put {txt word} {
    variable emoteicons

    if {[info exists emoteicons($word)]} {
	$txt image create end -image $emoteicons($word)
    }
}

proc emoteicons::load_dir {dir} {
    set icondef_path [file join $dir icondef.xml]
    if {![file isfile $icondef_path]} {
	### TODO: some error messages
	return
    }
    set f [open $icondef_path]
    set icondef [read $f]
    close $f

    set parser [jlib::wrapper:new "#" "#" \
		    [list emoteicons::parse_icondef $dir]]
    jlib::wrapper:elementstart $parser stream:stream {} {}
    jlib::wrapper:parser $parser parse $icondef
    jlib::wrapper:parser $parser configure -final 0
    jlib::wrapper:free $parser
}

proc emoteicons::parse_icondef {dir xmldata} {
    jlib::wrapper:splitxml $xmldata tag vars isempty chdata children

    if {$tag != "icondef"} {
	# TODO: error message
	return
    }

    foreach child $children {
	parse_item $dir $child
    }

}

proc emoteicons::parse_item {dir item} {
    jlib::wrapper:splitxml $item tag vars isempty chdata children

    switch -- $tag {
	name {}
	version {}
	description {}
	author {}
	creation {}
	meta {}
	icon {
	    parse_icon $dir $children
	}
    }
}

proc emoteicons::parse_icon {dir items} {
    variable txtdefaults
    variable txtlabels

    set txts {}
    set txtdefault ""
    set graphic ""
    foreach item $items {
	jlib::wrapper:splitxml $item tag vars isempty chdata children
	switch -- $tag {
	    text {
		lappend txts $chdata
		if {$txtdefault == "" || \
			[jlib::wrapper:getattr $vars default] == "true"} {
		    set txtdefault $chdata
		}
	    }
	    object {
		switch -- [jlib::wrapper:getattr $vars mime] {
		    image/gif {set graphic $chdata}
		}
	    }
	    graphic {
		# For compatibility with older versions of icondef.xml
		switch -- [jlib::wrapper:getattr $vars type] {
		    image/gif {set graphic $chdata}
		}
	    }
	    sound {}
	}
    }
    #debugmsg emoticons "E: $graphic; $txts"
    if {$graphic != ""} {
	set img [create_image $dir $graphic]
	foreach txt $txts {
	    emoteicons::add $txt $img
	}
	set txtdefaults($img) $txtdefault
	set txtlabels($img) [file rootname [file tail $graphic]]
    }
}

proc emoteicons::create_image {dir graphic} {
    set img $dir/$graphic
    image create photo $img -file [file join $dir $graphic]
    return $img
}

emoteicons::load_dir [fullpath emoticons-tkabber]

proc emoteicons::show_menu {iw} {
    variable txtdefaults
    variable txtlabels

    set m .emoticonsmenu
    if {[winfo exists $m]} {
	destroy $m
    }
    menu $m -tearoff 0
    set imgs [array names txtdefaults]
    set rows [expr {floor(sqrt([llength $imgs]))}]
    set row 0

    foreach img $imgs {
	if {$row >= $rows} {
	    $m add command -image $img -columnbreak 1 \
		-label $txtlabels($img) \
		-command [list [namespace current]::insert $iw \
						$txtdefaults($img)]
	    set row 1
	} else {
	    $m add command -image $img \
		-label $txtlabels($img) \
		-command [list [namespace current]::insert $iw \
						$txtdefaults($img)]
	    incr row
	}
    }

    bind $m <Any-Enter>  \
	[list [namespace current]::balloon $m enter  %X %Y %x %y]
    bind $m <Any-Motion> \
	[list [namespace current]::balloon $m motion %X %Y %x %y]
    bind $m <Any-Leave>  \
	[list [namespace current]::balloon $m leave  %X %Y %x %y]

    tk_popup $m [winfo pointerx .] [winfo pointery .]
}

# trying to get motion events in a menu is problematic...

proc emoteicons::balloon {w action X Y x y} {
    variable lasttext
    variable lastX
    variable lastY

    if {[cequal [set index [$w index @$x,$y]] none]} {
	if {![cequal $lasttext ""]} {
	    balloon::default_balloon $w leave $lastX $lastY
	}

	return
    }

    set text [$w entrycget $index -label]
    switch -- $action {
        motion {
            if {![cequal $text $lasttext]} {
		if {![cequal $lasttext ""]} {
                    balloon::default_balloon $w leave $lastX $lastY
		}

                balloon::default_balloon $w enter [set lastX $X] \
			[set lastY $Y] [set lasttext $text]
            }
        }

        leave {
            set lasttext ""
        }
    }

    balloon::default_balloon $w $action $X $Y $text
}

proc emoteicons::insert {iw text} {
    set p ""
    switch -- [$iw get "insert - 1 chars"] {
	"" - " " - "\n" {}

	default         { 
	    if {![cequal [$iw index "insert -1 chars"] 1.0]} {
		set p " "
	    }
	}
    }

    $iw insert insert "$p$text "
}

event add <<EmoteiconsMenu>> <Meta-e>
event add <<EmoteiconsMenu>> <Alt-e>

proc emoteicons::setup_bindings {chatid type} {
    set iw [chat::input_win $chatid]

    bind $iw <<EmoteiconsMenu>> \
	[list emoteicons::show_menu $iw]
    bind $iw <<EmoteiconsMenu>> +break
}


hook::add open_chat_post_hook emoteicons::setup_bindings
