/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KLESSONSTATUSSIZER_H
#define KLESSONSTATUSSIZER_H

#include "LEntry.H"
#include "LKrit.H"
#include <wx/wx.h>

/* Klasse fr die Lektionsstatusanzeige
 */
class KLessonStatusSizer : public wxFlexGridSizer {
 public:
  KLessonStatusSizer(wxWindow* parent);
  void setStatus(const LEntry& status, const LKrit& crit);
  
 private:
  //do not delete any of those pointers in a destructor!
  wxStaticText* touchesText; //total touches
  wxTextCtrl* touchesField;

  wxStaticText* tpmText; //touches per minute
  wxTextCtrl* tpmField;

  wxStaticText* correctText; //total correct touches
  wxTextCtrl* correctField;

  wxStaticText* wrongText; //total wrong touches
  wxTextCtrl* wrongField;

  wxBoxSizer* rateSizer;
  wxStaticText* rateText; //relative to thousands wrong touches
  wxTextCtrl* rateField;
  wxTextCtrl* reqrateField;

  wxBoxSizer* timeSizer;
  wxStaticText* timeText; //time
  wxTextCtrl* timeField;
  wxTextCtrl* reqtimeField;
};

#endif
