/***************************************************************************
                          lektionsanweisung.cpp  -  description                              
                             -------------------                                         
    begin                : Thu Jan 27 18:14:16 MET 2000 
                                           
    copyright            : (C) 1999 by Daniel Reith                         
    email                : DanR@gmx.de
	
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "lektionsanweisung.h"

#include "wx/sizer.h"
#include "wx/statline.h"
#include "wx/image.h"
#include "wx/ffile.h"
#include "wx/config.h"

enum
{
  // Controls
  TC = 101,
  OK  = 102
};

BEGIN_EVENT_TABLE(lektionsanweisung, wxDialog)
  EVT_BUTTON(OK, lektionsanweisung::OnSchliessen)
END_EVENT_TABLE()

  //****************************************************
  //* Konstruktor
  //****************************************************
  
lektionsanweisung::lektionsanweisung(wxWindow* parent, int Lektion, wxString k,  wxWindowID id , const wxString& title, const wxPoint& pos = wxDefaultPosition, 
const wxSize& size =wxDefaultSize, long style = wxDEFAULT_DIALOG_STYLE, const wxString& name = "dialogBox")
  : wxDialog(parent, id, title, pos, size, style, name)
{
  SetAutoLayout(TRUE);

wxBoxSizer *topsizer = new wxBoxSizer( wxVERTICAL );
 
#ifdef __WXMSW__
  wxBitmap::AddHandler(new wxPNGFileHandler);
#endif
#ifdef __WXGTK__
  wxImage::AddHandler(new wxPNGHandler);
#endif

   wxString f;

   wxConfigBase *pConfig = wxConfigBase::Get();
   wxString tlayout = pConfig->Read("/Tastatur/Layout", "german");
   
   f << L_DIR <<"/" << tlayout << "/lektion" << Lektion << ".png";
  wxBitmap logo(f, wxBITMAP_TYPE_PNG);
  if (!logo.Ok())
    {
      wxString error;
      error << _("Kann Datei ") << f << _(" nicht laden");
      wxLogError(error);
    }
  wxStaticBitmap *icon = new wxStaticBitmap(this, -1, logo);

  topsizer->Add(icon,  0, wxLEFT | wxRIGHT | wxTOP, 10);
  m_l = Lektion;
  wxString dir;
  wxString text;
  dir << L_DIR << "/" << tlayout << "/lektion.a" << m_l;
  wxFFile file(dir);
  if ( file.IsOpened() )
    {
      file.ReadAll(&text);
    }
  else
    {
      wxLogError(_("Datei kann nicht geladen werden"));
    }
  if (k!="")
    text << "\n" << k;
  topsizer->Add(CreateTextSizer(text) ,  0, wxEXPAND | wxLEFT | wxRIGHT | wxTOP,10);
  topsizer->Add( new wxStaticLine( this, -1 ), 0, wxEXPAND | wxLEFT|wxRIGHT|wxTOP, 10 );
  topsizer->Add( CreateButtonSizer(wxOK), 0, wxCENTRE | wxALL, 10 );
  
  topsizer->Fit(this);
  SetSizer(topsizer);
  Center();

}

//**********************************************
//* Fenster schlieen
//**********************************************
  
void lektionsanweisung::OnSchliessen(wxCommandEvent* event)
{
  EndModal(GetReturnCode());
}

//***********************************************
//* Lektionsanweisung und spter Bild laden
//***********************************************

bool lektionsanweisung::SetLektion(int l)
{
  m_l = l;
  wxString dir;
  dir << L_DIR << "lektion.a" << m_l;
    wxFFile file(dir);
    if ( file.IsOpened() )
    {
      wxString text;
      file.ReadAll(&text);
      tc->SetLabel(text);
    }
    else
    wxLogError(_("Datei kann nicht geladen werden"));

  //if (tc->LoadFile(dir)) return true; else return false;
    return true;
}
