/***************************************************************************
                          kurslaus.cpp  -  description                              
                             -------------------                                         
    begin                : Fri Jun  2 21:55:38 MEST 2000 
                                           
    copyright            : (C) 1999 by Daniel Reith                         
    email                : DanR@gmx.de
	
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "kurslaus.h"
#include "wx/sizer.h"
#include "wx/statline.h"

//**************************************************
//
//            Event Table fr kurslaus
//
//**************************************************


enum
{
  mOK = 23,
  mCancel = 24
};

BEGIN_EVENT_TABLE(kurslaus, wxDialog)
  EVT_BUTTON(mOK, kurslaus::OnOK)
  EVT_BUTTON(mCancel, kurslaus::OnCancel)
END_EVENT_TABLE()
  
//*************************************************
// Konstruktor
//*************************************************

kurslaus::kurslaus(wxWindow *parent, Lektion *lektion, LKrit krit)
  : wxDialog(parent, -1, _("Lektionsauswertung"), wxDefaultPosition, wxSize(500, 300), wxDEFAULT_DIALOG_STYLE, "Lektionsauwertung")
{
  wxString t;
  t << _("Lektion ") << krit.GetNummer();
  m_text = new wxStaticText(this, -1, t, wxPoint(5,5), wxSize(495, 50), wxALIGN_CENTRE);
  m_text->SetFont(wxFont(24, wxDEFAULT, wxNORMAL, wxBOLD));
  m_grid = new wxGrid(this, -1, wxPoint(5, 50), wxSize(495, 200));
  m_grid->CreateGrid(5,2);
  m_grid->SetColumnWidth(0, 130);
  m_grid->SetColumnWidth(1, 130);
  m_grid->SetRowHeight(0, 26);
  m_grid->SetRowHeight(1, 26);
  m_grid->SetRowHeight(2, 26);
  m_grid->SetRowHeight(3, 26);
  m_grid->SetRowHeight(4, 26);
  m_grid->SetCellAlignment(wxRIGHT,1 , 1);
  // Die Funktion SetColLabelValue funktioniert nur bei mir, komisch
  //m_grid->SetColLabelValue(0, _("erlaubt"));
  m_grid->SetLabelValue(wxHORIZONTAL, _("erlaubt"), 0);
  //  m_grid->SetColLabelValue(1, _("Ihr Ergebnis"));
  m_grid->SetLabelValue(wxHORIZONTAL, _("Ihr Ergebnis"), 1);
  //m_grid->SetRowLabelValue(0, _("Anschlge (ges)"));
  m_grid->SetLabelValue(wxVERTICAL, _("Anschlge (ges)"), 0);
  //  m_grid->SetRowLabelValue(1, _("falsche Anschlge"));
  m_grid->SetLabelValue(wxVERTICAL, _("falsche Anschlge"), 1);
  //  m_grid->SetRowLabelValue(2, _("falsche Anschlge o/oo"));
  m_grid->SetLabelValue(wxVERTICAL, _("falsche Anschlge o/oo"), 2);
  //  m_grid->SetRowLabelValue(3, _("Zeit"));
  m_grid->SetLabelValue(wxVERTICAL, _("Zeit"), 3);
  //  m_grid->SetRowLabelValue(4, _("Anschlge / Minute"));
  m_grid->SetLabelValue(wxVERTICAL, _("Anschlge / Minute"), 4);
  for (int i=0; i <=1; ++i)
    for (int k=0; k<=4; ++k)
      {
	// Funktioniert nur bei mir
	//m_grid->SetReadOnly(k, i, TRUE);
	// bei Felix geht nur die Allgemeine Funktion
	m_grid->SetCellAlignment(wxRIGHT, k, i);
      }
  m_grid->SetEditable(FALSE);
  // Spalte erlaubt mit Werten fllen
  wxString s;
  s << krit.GetPromille();
  m_grid->SetCellValue(s, 2, 0);
  s = "";
  // Falls krit.GetZeit == 0 ist, dann ist die Zeit nicht relevant.
  if (krit.GetUnixZeit()!=0)
    {
      s << krit.GetZeit();
      m_grid->SetCellValue(s, 3, 0);
    }
  // Ihr Ergebnis fllen
  s= "";
  s  << lektion->GetAnschlaege(); 
  m_grid->SetCellValue(s, 0, 1);
  s = "";
  s << lektion->GetFehler();
  m_grid->SetCellValue(s, 1, 1);
  s = "";
  s << lektion->GetFP();
  // Falls die Fehlerpromillezahl zu hoch liegt, wird es rot geschrieben
  if (lektion->GetFP()>krit.GetPromille())
    m_grid->SetCellTextColour(*wxRED, 2, 1);
  if ((krit.GetUnixZeit()>0)&&(lektion->GetUnixZeit()>krit.GetUnixZeit()))
    m_grid->SetCellTextColour(*wxRED, 3, 1); 
  m_grid->SetCellValue(s, 2, 1);
  m_grid->SetCellValue(lektion->GetZeit(), 3, 1);
  s = "";
  s << lektion->GetApM();
  m_grid->SetCellValue(s, 4, 1);
  m_grid->SetLabelSize(wxVERTICAL, 150);
  wxString oktext;
  // Wenn eine der Bedingungen nicht erfllt ist (Zeit berschritten oder zu viele Fehler, mu
  // die Lektion wiederholt werden
  if (((krit.GetUnixZeit()>0)&&(lektion->GetUnixZeit()>krit.GetUnixZeit()))||(lektion->GetFP()>krit.GetPromille()))
    oktext = _("Lektion wiederholen");
  else
    oktext = _("Nchste Lektion");
  m_OK = new wxButton(this, mOK, oktext, wxPoint(50, 260), wxSize(150, 30));
  m_Cancel = new wxButton(this, mCancel, _("Kurs abbrechen"), wxPoint(300, 260), wxSize(150, 30));
  Center();
}

void kurslaus::OnOK(wxCommandEvent* event)
{
  EndModal(wxOK);
}

void kurslaus::OnCancel(wxCommandEvent* event)
{
  EndModal(wxCANCEL);
}
