#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <string.h>

#include "tilp_cb.h"
#include "tilp_dbox.h"
#include "support.h"

#include "tilibs.h"
#include "struct.h"
#include "gstruct.h"
#include "defs.h"
#include "sub_main.h"
#include "version.h"
#include "fsel_dbox.h"
#include "gui_indep.h"
#include "error.h"
#include "cb_calc.h"
#include "cb_misc.h"
#include "files.h"
#include "rcfile.h"
#include "select.h"

#include "screendump_cb.h"
#include "general_cb.h"
#include "scopt_cb.h"
#include "font_cb.h"
#include "link_cb.h"
#include "calc_cb.h"
#include "linkspeed_cb.h"
#include "probeio_cb.h"
#include "term_cb.h"
#include "help_cb.h"
#include "manpage_cb.h"
#include "thanks_cb.h"
#include "extprgms_cb.h"
#include "about_cb.h"
#include "startup_dbox.h"
#include "lang_cb.h"
#include "advanced_cb.h"
#include "gfm_cb.h"
#include "msg_cb.h"
#include "user_cb.h"
#include "shell_cb.h"
#include "clist.h"
#include "ctree.h"
#include "ginfo.h"
#include "select.h"
#include "pbar_cb.h"
#include "help_cb.h"
#include "about_cb.h"
#include "advanced_cb.h"
#include "advanced_cb.h"
#include "gfm_cb.h"
#include "clist_rbm.h"
#include "fsel_cb.h"
#include "wizard_cb.h"
#include "gtoolbar.h"
#include "plugins_cb.h"

/******************************************************/
/* Display the main box and keep some widget pointers */
/******************************************************/

GtkWidget* display_tilp_dbox()
{
  GtkWidget *dbox;
  gpointer user_data;
  guint id;
  gchar buffer[MAXCHARS];

  dbox = create_tilp_dbox();

  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "clist1");
  clist_wnd = GTK_WIDGET(user_data);
  gtk_clist_set_column_width(GTK_CLIST (clist_wnd), 0, 16);  //
  gtk_clist_set_column_width(GTK_CLIST (clist_wnd), 1, 120); //filename
  gtk_clist_set_column_width(GTK_CLIST (clist_wnd), 2, 90);  //date
  gtk_clist_set_column_width(GTK_CLIST (clist_wnd), 3, 65);  //size
  gtk_clist_set_column_width(GTK_CLIST (clist_wnd), 4, 60);  //user
  gtk_clist_set_column_width(GTK_CLIST (clist_wnd), 5, 60);  //group
  gtk_clist_set_column_width(GTK_CLIST (clist_wnd), 6, 70);  //attributes

  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "ctree1");
  ctree_wnd = GTK_WIDGET(user_data);
  gtk_clist_set_column_width(GTK_CLIST (ctree_wnd), 0, 135); //varname
  gtk_clist_set_column_width(GTK_CLIST (ctree_wnd), 1, 25);  //attributes
  gtk_clist_set_column_width(GTK_CLIST (ctree_wnd), 2, 50);  //type
  gtk_clist_set_column_width(GTK_CLIST (ctree_wnd), 3, 30);  //size
  //gtk_ctree_set_indent (GTK_CTREE (ctree_wnd), 17);
  gtk_clist_set_row_height(GTK_CLIST (ctree_wnd), 16);

  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "label21");
  clabel_win.label21 = GTK_WIDGET(user_data);
  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "label22");
  clabel_win.label22 = GTK_WIDGET(user_data);
 
  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "toolbar1");
  toolbar_win.toolbar = GTK_WIDGET(user_data);
  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "button4");
  toolbar_win.button1 = GTK_WIDGET(user_data);
  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "button5");
  toolbar_win.button3 = GTK_WIDGET(user_data);
  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "button6");
  toolbar_win.button4 = GTK_WIDGET(user_data);
  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "button7");
  toolbar_win.button5 = GTK_WIDGET(user_data);
  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "button8");
  toolbar_win.button6 = GTK_WIDGET(user_data);
  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "button9");
  toolbar_win.button7 = GTK_WIDGET(user_data);
  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "button10");
  toolbar_win.button8 = GTK_WIDGET(user_data);
  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "button11");
  toolbar_win.button9 = GTK_WIDGET(user_data);
  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "button12");
  toolbar_win.button10 = GTK_WIDGET(user_data);

  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "statusbar1");
#ifdef HAVE_LIBTIFFEP
  g_snprintf(buffer, MAXCHARS, "  Version %s (cable=%s, calc=%s, tiffep=%s)", 
	     TILP_VERSION,
	     ticable_get_version(),
	     ticalc_get_version(),
	     tiffep_get_version());
#else
  g_snprintf(buffer, MAXCHARS, "Version %s (%s %s %s)", 
	     TILP_VERSION,
	     ticable_get_version(),
	     ticalc_get_version(),
	     "NA");
#endif
  id = gtk_statusbar_get_context_id(GTK_STATUSBAR(user_data), buffer);
  gtk_statusbar_push(GTK_STATUSBAR(user_data), id, buffer);  

  return dbox;
}

void
on_tilp_dbox_destroy                   (GtkObject       *object,
                                        gpointer         user_data)
{
  int err = 0;

  if( (err=link_cable.exit()) )
    {
      fprintf(stderr, "link_cable.exit: error code %i\n", err);
      tilp_error(err);
    }
  gtk_widget_destroy(GTK_WIDGET(user_data));
  gtk_main_quit();
}

/******************/
/* Menu callbacks */
/******************/

void
on_unzip_archive1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gchar *cmdline;
  gchar *s;
  gchar buffer[MAXCHARS];
  FILE *p;
  GList *ptr;
  struct file_info *f;
  int ret;
#ifdef __WIN32__
  gint n;
#endif

  if(clist_win.selection==NULL)
    {
      msg_box(_("Information"), 
	      _("A file must have been selected."));
      return;
    }
  
  /* 
     Detect whether the program is available else error !
  */
  p = popen(options.unzip_location, "r");
  if(p == NULL)
    {
      msg_box(_("Error"), 
	      _("It seems that the 'unzip' program is unavailable.\nWindows users: you must have the 'WinZip Command Line Support Add-On' (233 Kb) for this. If not, \nyou can download it at www.winzip.com."));
      return;
    }
  pclose(p);
  
  ptr=clist_win.selection;
  while(ptr!=NULL)
    {
      f=(struct file_info *)ptr->data;
      printf("File to unzip: <%s>\n", f->filename);
      
      /* Unzip the file archive */
      cmdline = (gchar *)g_malloc((strlen(options.unzip_location) +
				   strlen(options.unzip_options) + 1 + MAXCHARS) *
				  sizeof(gchar));
      strcpy(cmdline, options.unzip_location);
      strcat(cmdline, " ");
      if(!strcmp(options.unzip_options, ""))
#if defined(__LINUX__)
	{ // default options
	  strcat(cmdline, "-o "); // overwrite
	  strcat(cmdline, "-d "); // unzip in a sub directory
	  sprintf(buffer, "%s", f->filename);
	  s = (gchar *)strrchr(buffer, '.');
	  if(s != NULL)
	    buffer[strlen(buffer) - strlen(s)] = '\0';
	  strcat(cmdline, buffer);
	}
#elif defined(__WIN32__)
      { // default options
	strcat(cmdline, "-o "); // overwrite
	strcat(cmdline, "-d "); // unzip in a sub directory
	/*
	  sprintf(buffer, "%s", f->filename);
	  printf("-> <%s>\n", buffer);
	  s = strrchr(buffer, '.');
	  if(s != NULL)
	  buffer[strlen(buffer) - strlen(s)] = '\0';
	*/
	strcat(cmdline, buffer);
      }
#endif
      else
	{ // user options
	  strcat(cmdline, options.unzip_options);
	}
      strcat(cmdline, " ");
      sprintf(buffer, "%s", f->filename);
      strcat(cmdline, buffer);
      
      fprintf(stdout, "Unzip cmdline: <%s>\n", cmdline);
#ifdef __WIN32__ // is being to change...
      p = popen(cmdline,"r");
      if(p == NULL)
	{
	  msg_box(_("Error"), 
		  _("Unable to unzip the file."));
	  return;
	}
      
      while( (n = fread(buffer, sizeof(gchar), 255, p)) > 0 )
	{  
	  buffer[n-1] ='\0';
	  printf("%s", buffer);
	}
      ret = pclose(p);
#elif defined(__LINUX__)
      ret = execute_command(cmdline);
#endif
      if(ret == -1)
	{
	  msg_box(_("Error"), 
		  _("There was some errors with unzip."));
	  return;
	}
      DISPLAY(_("\ntilp -> Unzip command finished.\n"));
      
      ptr=ptr->next;
    }
  
  //refresh_clist(main_window);

  return;
}


void
on_untar_archive1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gchar *cmdline;
  FILE *p;
  GList *ptr;
  struct file_info *f;
  int ret;
 #ifdef __WIN32__
  gint n;
  gchar buffer[MAXCHARS];
#endif


  if(clist_win.selection==NULL)
    {
      msg_box(_("Information"), 
	      _("A file must have been selected."));
      return;
    }
  
  /* 
     Detecter si un prg est dispo, sinon err_box
  */
  p = popen(options.tar_location, "r");
  if(p == NULL)
    {
      msg_box(_("Error"), 
	      _("It seems that the 'unzip' program is unavailable.\nWindows users: you must have the 'WinZip Command Line Support Add-On' (233 Kb) for this. Else, \nyou can download it at www.wintar.com."));
      return;
    }
  pclose(p);
  
  ptr=clist_win.selection;
  while(ptr!=NULL)
    {
      f=(struct file_info *)ptr->data;
      printf("File to untar: <%s>\n", f->filename);
      
      /* Untar the file archive */
      cmdline = (gchar *)g_malloc((strlen(options.tar_location) +
				   strlen(options.tar_options) + 
				   1 + MAXCHARS) * sizeof(gchar));
      strcpy(cmdline, options.tar_location);
      strcat(cmdline, " ");
      if(!strcmp(options.tar_options, ""))
#if defined(__LINUX__)
	{ // default options
	  strcat(cmdline, "x"); // extract
	  strcat(cmdline, "v"); // verbose
	  strcat(cmdline, "z"); // gzipped
	  strcat(cmdline, "f"); // force = overwrite
 	  strcat(cmdline, " ");
	  strcat(cmdline, f->filename);
	}
#elif defined(__WIN32__) //??
      { // default options
	strcat(cmdline, "-o "); // overwrite
	strcat(cmdline, "-d "); // untar in a sub directory
	strcat(cmdline, buffer);
      }
#endif
      else
	{ /* user's options */
	  strcat(cmdline, options.tar_options);
	  strcat(cmdline, " ");
	  strcat(cmdline, f->filename);
	}
      fprintf(stdout, "Untar cmdline: <%s>\n", cmdline);
#ifdef __WIN32__ // is being to change...
      p = popen(cmdline,"r");
      if(p == NULL)
	{
	  msg_box(_("Error"), 
		  _("Unable to untar the file."));
	  return;
	}
      
      while( (n = fread(buffer, sizeof(gchar), 255, p)) > 0 )
	{  
	  buffer[n-1] ='\0';
	  printf("%s", buffer);
	}
      ret = pclose(p);
#elif defined(__LINUX__)
      ret = execute_command(cmdline);
#endif
      if(ret == -1)
	{
	  msg_box(_("Error"), 
		  _("There was some errors with untar."));
	  return;
	}
      DISPLAY(_("\ntilp -> Untar command finished.\n"));
      
      ptr=ptr->next;
    }
  //refresh_clist(main_window);
 
  return;
}


void
on_save_config1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  cb_save_config_file();
}


void
on_reload_config1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  cb_load_config_file();
}


void
on_default_config1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  cb_default_config();
}


void
on_quit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  int err;

  if( (err=link_cable.exit()) )
    {
      fprintf(stderr, "link_cable.term_port: error code %i\n", err);
      tilp_error(err);
    }
  gtk_widget_destroy(GTK_WIDGET(user_data));
  gtk_main_quit();
}


void
on_general1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_general_dbox();
}


void
on_screen_capture1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_scopt_dbox();
}


void
on_font_type1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_font_dbox();
}


void
on_hardware1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_linktype_dbox();
}


void
on_calculator1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_calctype_dbox();
}

void
on_link_speed1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_linkspeed_dbox();
}


void
on_probe_i_o_ports1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_probeio_dbox();
}


void
on_probe_link_cable1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  //cb_probe_cable();
}


void
on_probe_calc_type1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  cb_probe_calc();
}


void
on_ready____1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  cb_calc_is_ready();
}


void
on_terminal___remote1_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if(is_active)
    return;
  display_term_dbox();
}


void
on_screenshot1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_screendump_dbox();
}


void
on_directory_list1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ctree_selection_destroy();
  if(cb_dirlist() != 0) return;
  
  refresh_ctree(main_window);
  refresh_info();
}


void
on_send_backup1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  int ret;

  /* Information box */
  ret = user2_box(_("Warning"), 
		  _("You are going to restore the calculator content with your backup. The whole memory will be erased. Are you sure you want to do that ?"),
		  _("Next >"), 
		  _("Cancel"));
  if(ret != BUTTON1)
    return;

  display_fileselection_2();
}


void
on_receive_backup1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if(cb_recv_backup() != 0)
    return;

  display_fileselection_3();

  clist_selection_destroy();
  l_directory_list();
  refresh_clist(main_wnd);
  refresh_info(main_wnd);
}


void
on_send_variable1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if(cb_send_var() != 0)
    return;

  clist_selection_destroy(); // GUI independant
  clist_selection_refresh(); // GUI dependant
}


void
on_receive_variable1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  int ret = 0;

  ret = cb_recv_var();
  if(ret < 0) return;
  
  if(ret > 0)
    display_fileselection_4();
  
  if(menuitem == NULL) return;

  ctree_selection_destroy();
  ctree_selection_refresh();
  clist_selection_destroy();
  l_directory_list();
  refresh_clist(main_window);
  refresh_info();
}


void
on_receive_application1_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if(cb_recv_app() != 0) return;

  if(menuitem == NULL) return;
  
  ctree_selection_destroy();
  ctree_selection_refresh();
  clist_selection_destroy();
  l_directory_list();
  refresh_clist(main_window);
  refresh_info();
}


void
on_send__free__application1_activate   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  char *msg = _("You are going to send a FLASH application on your calculator.\nHe is strongly recommended for Windows users to close any application and eventually turn off your screen saver (this makes the transfer rate decrease !). Tests have been made on a PC350 Mhz and all link cables without any problems.");
  gint ret;
  
  ret=user2_box(_("Warning"), msg,
		_("Continue"), _("Cancel"));
  if(ret == BUTTON2)
    return;
  
  display_fileselection_8();
}


void
on_send_operating_system1_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  char *msg =_("You are going to FLASH the Operating System of your calculator.\nHe is strongly recommended for Windows users to close any application and to turn off your screen saver (this makes the transfer rate decrease !). Tests have been made on a PC350 Mhz and all link cables without any problems. If the transfer crashes, wait until the TI92+ displays 'Waiting to receive' and try the transfer again.");
  gint ret;

  ret=user2_box(_("Warning"), msg,
		_("Continue"), _("Cancel"));
  if(ret == BUTTON2)
    return;
  
  display_fileselection_9();
}


void
on_get_idlist1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  cb_id_list();
}


void
on_rom_dump1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if(cb_rom_dump()) return;
  
  display_fileselection_7();

  clist_selection_destroy();
  l_directory_list();
  refresh_clist(main_wnd);
  refresh_info(main_wnd);  
}


void
on_rom_version1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  cb_rom_version();
}

void
on_options1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
#ifdef HAVE_TIFFEP
  display_plugins_dbox();
#else
  msg_box(_("Information"), 
	  _("TiLP has not been compiled with TIFFEP ('TI file format engine & proxy') server support..."));
#endif
}


void
on_load_list1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
#ifdef HAVE_TIFFEP
  gint err;
  gchar buffer[MAXCHARS];
  
  err = tiffep_registry_get_pointer(&plugin_registry);
  if(!err)
    registry_allowed = TRUE;
  else
    {
      registry_allowed = FALSE;
      
      tiffep_get_error(err, buffer);
      msg_box(_("Error"), buffer);
    }
#else
  msg_box(_("Information"), 
	  _("TiLP has not been compiled with TIFFEP ('TI file format engine & proxy') server support..."));
#endif
}


void
on_list1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
#ifdef HAVE_TIFFEP
  display_registry_dbox();
#else
  msg_box(_("Information"), 
	  _("TiLP has not been compiled with TIFFEP ('TI file format engine & proxy') server support...")); 
#endif
}


void
on_register_files1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  cb_registry_register();
}


void
on_unregister_files1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  cb_registry_unregister();
}


void
on_external_programs1_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_extprgms_dbox();
}


void
on_help2_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_help_dbox();
}


void
on_manpage1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_manpage_dbox();
}


void
on_thanks1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_thanks_dbox();
}


void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_about_dbox();
}

void
on_changelog1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gtk_widget_show_all(create_startup_dbox()); // not display_
}


void
on_language1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_lang_dbox();
}


void
on_associations1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_advanced1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_advanced_dbox();
}


void
on_group_file_manager1_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_gfm_dbox("");
}

void
on_convert_flash_to_rom1_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_fileselection_10();
}

/*****************************/
/* Toolbar buttons callbacks */
/*****************************/

/* Ready buton */
void
on_tilp_button4_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  if(cb_calc_is_ready() != 0)
    return;
}

/* Screendump button */
void
on_tilp_button5_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  display_screendump_dbox();
}

/* Dirlist button */
void
on_tilp_button6_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  if(cb_dirlist() != 0) return;
  
  refresh_ctree(main_window);
  refresh_info();
}

/* Backup button */
void
on_tilp_button7_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  if(cb_recv_backup() != 0) 
    return;

  display_fileselection_3();
}

/* Restore button */
void
on_tilp_button8_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  int ret;

  /* Information box */
  ret = user2_box(_("Warning"), 
		  _("You are going to restore the calculator content with your backup. The whole memory will be erased. Are you sure you want to do that ?"),
		  _("Next >"), 
		  _("Cancel"));
  if(ret != BUTTON1)
    return;

  display_fileselection_2();
}

/* Send/Receive button */
void
on_tilp_button9_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  if( (ctree_win.selection != NULL) || (ctree_win.selection2 != NULL) )
    {
      if(ctree_win.selection != NULL)
	on_receive_variable1_activate(NULL, NULL);
      if(ctree_win.selection2 != NULL)
	on_receive_application1_activate(NULL, NULL);
      
      ctree_selection_destroy();
      ctree_selection_refresh();
      clist_selection_destroy();
      l_directory_list();
      refresh_clist(main_window);
      refresh_info();
    }
  
  else if(clist_win.selection != NULL)
    on_send_variable1_activate(NULL, NULL);
  else if( (options.lp.calc_type == CALC_TI82) | 
	   (options.lp.calc_type == CALC_TI85) )
    on_receive_variable1_activate(NULL, NULL);
}

/* Mkdir button */
void
on_tilp_button10_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  gchar *dirname;

  dirname=gif->dlgbox_entry(_("Make a new directory"), 
			    _("Name: "), 
			    _("new_directory"));
  if(dirname == NULL) return;

  { /* [X91] temporarily drop root privileges */
#ifdef __LINUX__
    uid_t effective;
    
    effective = geteuid();
    seteuid(getuid());
#endif
    if (mkdir(dirname, 255))
      {
	msg_box(_("Information"), _("Unable to create the directory.\n\n"));
	g_free(dirname);
      }
#ifdef __LINUX__
    seteuid(effective);
#endif
  }

  g_free(dirname);
  clist_selection_destroy();
  l_directory_list();
  refresh_clist(main_window);
  refresh_info();
}

/* Trash button */
void
on_tilp_button11_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  delete_selected_files();
  
  clist_selection_destroy();
  l_directory_list();
  refresh_clist(main_wnd);
  refresh_info();
}

/* Refresh button */
void
on_tilp_button12_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  clist_selection_destroy();
  l_directory_list();
  refresh_clist(button);
  refresh_info();
}

/*******************/
/* CTree callbacks */
/*******************/

gint last_status = 0;

/* A button has been pressed in the CTree */
gboolean
on_ctree1_button_press_event           (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkCList *clist;
  GtkCTree *ctree;
  GtkCTreeNode *node;
  gint x, y;
  gint row, column;
  static GList *selected_dir=NULL;

  x = event->x;
  y = event->y;

  clist = GTK_CLIST (widget);
  ctree = GTK_CTREE (widget);
  if (!gtk_clist_get_selection_info (clist, x, y, &row, &column)) 
    return FALSE;
  node=GTK_CTREE_NODE (g_list_nth (clist->row_list, row));

  if( (GTK_CTREE_ROW(node)->children != NULL) && (last_status == 0) )
    {
      if(g_list_find(selected_dir, (gpointer)node)!=NULL)
	{
	  selected_dir=g_list_remove(selected_dir, (gpointer)node);
	  gtk_ctree_unselect_recursive(ctree, node);
	}
      else
	{
	  gtk_ctree_select_recursive(ctree, node);
	  selected_dir=g_list_append(selected_dir, (gpointer)node);
	}
    }
  last_status=0;

  return FALSE;
}

/* A row have been selected */
void
on_ctree1_tree_select_row              (GtkCTree        *ctree,
                                        GList           *node,
                                        gint             column,
                                        gpointer         user_data)
{
  clist_selection_destroy();
  clist_selection_refresh();

  if(GTK_CTREE_ROW(node)->children == NULL)
    {
      struct varinfo *v;
      v=(struct varinfo *)gtk_ctree_node_get_row_data(ctree, GTK_CTREE_NODE(node));
      if(v->vartype != ticalc_flash_type(options.lp.calc_type))
	{
	  ctree_win.selection = 
	    g_list_append(ctree_win.selection, 
	    gtk_ctree_node_get_row_data(ctree, GTK_CTREE_NODE(node)));
	}
      else
	{
	  ctree_win.selection2 = 
	    g_list_append(ctree_win.selection2, 
	    gtk_ctree_node_get_row_data(ctree, GTK_CTREE_NODE(node)));
	}
    }

  refresh_info();
  refresh_sensitive_toolbar_buttons();
}

/* A row of the tree has been unselected */
void
on_ctree1_tree_unselect_row            (GtkCTree        *ctree,
                                        GList           *node,
                                        gint             column,
                                        gpointer         user_data)
{
  if(GTK_CTREE_ROW(node)->children == NULL)
    {
      ctree_win.selection=g_list_remove(ctree_win.selection, 
        gtk_ctree_node_get_row_data(ctree, GTK_CTREE_NODE(node)));
    }
  refresh_info();
  refresh_sensitive_toolbar_buttons();
}

/* A column has been clicked in the CTree */
void
on_ctree1_click_column                 (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
  switch(column)
    {
    case 0:
      options.ctree_sort=SORT_BY_NAME;
      break;
    case 1:
      options.ctree_sort=SORT_BY_INFO;
      break;
    case 2:
      options.ctree_sort=SORT_BY_TYPE;
      break;
    case 3:
      options.ctree_sort=SORT_BY_SIZE;
      break;
    }

  refresh_ctree();
  ctree_selection_refresh();
}



/* A node has been expanded */
void
on_ctree1_tree_expand                  (GtkCTree        *ctree,
                                        GList           *node,
                                        gpointer         user_data)
{
  last_status = 1;
}

/* A node has been collapsed */
void
on_ctree1_tree_collapse                (GtkCTree        *ctree,
                                        GList           *node,
                                        gpointer         user_data)
{
  last_status=1;
}


/*******************/
/* CList callbacks */
/*******************/

static gint last_status2=0;

/* A button has been pressed in the CList */
gboolean
on_tilp_clist1_button_press_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  gchar *name, *attrib;
  gint row, column;
  GdkEventButton *bevent;
  char *home_dir;
  
  if (!gtk_clist_get_selection_info (GTK_CLIST (widget), 
				     event->x, event->y, &row, &column)) 
    return FALSE; // FALSE ??
  gtk_clist_get_text(GTK_CLIST(widget), row, 1, &name);
  gtk_clist_get_text(GTK_CLIST(widget), row, 6, &attrib);
  switch(event->type)
    {
    case GDK_BUTTON_PRESS: // third button clicked
      if(event->button==3)
	{
	  //gtk_clist_select_row(GTK_CLIST(widget), row, column);
	  bevent=(GdkEventButton *)(event);
	  gtk_menu_popup(GTK_MENU(create_clist_rbm ()), 
			 NULL, NULL, NULL, NULL, 
			 bevent->button, bevent->time);
	}
      break;
    case GDK_2BUTTON_PRESS: // double click
      if(attrib[1]=='d')
	{
	  last_status2=1;
	  //gtk_clist_freeze(GTK_CLIST (widget));
	  
	  { /* [X91] temporarily drop root privileges */
#ifdef __LINUX__
	    uid_t	effective;
	    
	    effective = geteuid();
	    seteuid(getuid());
#endif
	    if (chdir(name))
	      msg_box(_("Error"),
		      _("Unable to change of directory."));
#ifdef __LINUX__
	    seteuid(effective);
#endif
	  }
	  
	  /* Retrieve current working directory */
	  g_free(clist_win.cur_dir);
	  clist_win.cur_dir = g_get_current_dir();
	  
	  // do not allow LINUX users to go outside their HOME dir
	  // unless user forces it at compilation time (thanks to K. Kofler
	  // for this suggestion)
#if defined(__LINUX__) && !defined(ALLOW_EXIT_HOMEDIR) 
	  get_home_path(&home_dir);

	  /* If clist_win.cur_dir does not begin with "home_dir"
	   * or strlen(clist_win.cur_dir) < strlen(home_dir)
	   * then the user is trying to escape its home directory.
	   */

	  if ((strlen(clist_win.cur_dir) < strlen(home_dir)) || (strncmp (clist_win.cur_dir, home_dir, strlen (home_dir)) != 0))
	    {
	      chdir(home_dir);
	      g_free(clist_win.cur_dir);
	      clist_win.cur_dir = g_get_current_dir();
	      
	      msg_box(_("Error"),
		      _("You can not go outside of your HOME directory."));
	      return FALSE;
            }
	  g_free(home_dir);
#endif

	  clist_selection_destroy();
	  l_directory_list();
	  refresh_clist();
	  refresh_info();
	}
      break;
    default:
      break;        
    }

  return FALSE;
}


/* A row has been selected in the CList */
void
on_tilp_clist1_select_row              (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gchar *name, *attrib;
  gchar *full_name;

  gtk_clist_get_text(clist, row, 1, &name);
  gtk_clist_get_text(clist, row, 6, &attrib);
  
  ctree_selection_destroy();
  ctree_selection_refresh();

  if(gtk_clist_get_selectable(clist, row))
    {
      clist_win.selection = 
	g_list_append(clist_win.selection, gtk_clist_get_row_data(clist, row));
      
      full_name=g_strconcat(clist_win.cur_dir, DIR_SEPARATOR, name, NULL);
      clist_win.file_selection=g_list_append(clist_win.file_selection, 
					      (gpointer)full_name);
    }

  if(last_status2)
    {
      last_status2=0;
      gtk_clist_unselect_row(clist, row, 1);
    }
  refresh_info();
  refresh_sensitive_toolbar_buttons();
}

static gint GCompareStrings (gconstpointer a, gconstpointer b)
{
  return strcmp((gchar *)a, (gchar *)b);
}

/* A row has been unselected in the CList */
void
on_tilp_clist1_unselect_row            (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gchar *name, *attrib;
  gchar *full_name;

  gtk_clist_get_text(clist, row, 1, &name);
  gtk_clist_get_text(clist, row, 6, &attrib);
  
  if(gtk_clist_get_selectable(clist, row))
    {
      clist_win.selection=g_list_remove(clist_win.selection, gtk_clist_get_row_data(clist, row));
      
      full_name=g_strconcat(clist_win.cur_dir, DIR_SEPARATOR, name, NULL);
      clist_win.file_selection=g_list_remove(clist_win.file_selection, 
					     g_list_find_custom(clist_win.file_selection, full_name, GCompareStrings)->data);
      g_free(full_name);
    }
  refresh_info();
  refresh_sensitive_toolbar_buttons();
}


/* A column button has been clicked in the CList */
void
on_tilp_clist1_click_column            (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
  switch(column)
    {
    case 0:
      options.clist_sort_order=!options.clist_sort_order; 
      break;
    case 1:
      options.clist_sort=SORT_BY_NAME;
      break;
    case 2:
      options.clist_sort=SORT_BY_DATE;
      break;
    case 3:
      options.clist_sort=SORT_BY_SIZE;
      break;
    case 4:
      options.clist_sort=SORT_BY_USER;
      break;
    case 5:
      options.clist_sort=SORT_BY_GROUP;
      break;
    case 6:
      options.clist_sort=SORT_BY_ATTRB;
      break; 
    }

  refresh_clist();
  refresh_info();
}

void
on_wizard_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_wizard_dbox();
}

/**/
