#include <stdio.h>
#include <jvmti.h>
#include <tijmp.h>
#include <find_child_objects.h>
#include <tag_list.h>
#include <walk_heap.h>
#include <tijmp_class_handler.h>

extern jvmtiEnv* jvmti;
extern jlong current_object_tag;

typedef struct {
    tag_list* tl;
    tag_list* tijmp_classes;
} tlp;

static jint JNICALL fco (jvmtiHeapReferenceKind reference_kind, 
		 const jvmtiHeapReferenceInfo* reference_info, 
		 jlong class_tag, jlong referrer_class_tag, 
		 jlong size, jlong* tag, jlong* referrer_tag_ptr, 
		 jint length, void* user_data) {
    tlp* p = (tlp*)user_data;
    
    /* ignore all odd references... */
    if (reference_kind != JVMTI_HEAP_REFERENCE_FIELD &&
	reference_kind != JVMTI_HEAP_REFERENCE_ARRAY_ELEMENT)
	return 0;

    /* ignore references to and from tijmp classes. */
    if (is_tijmp_class (referrer_class_tag, p->tijmp_classes))
	return 0;
    if (is_tijmp_class (class_tag, p->tijmp_classes))
	return JVMTI_VISIT_OBJECTS;

    if (*tag == 0)
	*tag = current_object_tag--;    

    add_tag (p->tl, *tag);
    return JVMTI_VISIT_OBJECTS;
}

void JNICALL find_all_child_objects (JNIEnv *env, jobject o) {
    jvmtiError err;
    jvmtiHeapCallbacks callbacks;
    jint count;
    jobject* objects;
    jint i;
    jobjectArray oa;
    jclass cls;
    jmethodID m;
    jint class_count;
    jclass* cp = NULL;
    jclass** classes = &cp;
    tag_list so;
    tag_list tijmp_classes;
    tlp p;
    
    tag_classes (env, &class_count, classes);
    (*jvmti)->Deallocate (jvmti, (unsigned char*)classes[0]);

    setup_tag_list (env, &tijmp_classes, NULL);
    find_tijmp_classes (env, &tijmp_classes);

    setup_tag_list (env, &so, NULL);
    callbacks.heap_iteration_callback = 0;
    callbacks.heap_reference_callback = fco;
    callbacks.primitive_field_callback = 0;
    callbacks.array_primitive_value_callback = 0;
    callbacks.string_primitive_value_callback = 0;
    (*jvmti)->SetTag (jvmti, o, -1);

    p.tl = &so;
    p.tijmp_classes = &tijmp_classes;
    err = (*jvmti)->FollowReferences (jvmti, 0, NULL, o, &callbacks, &p);
    if (err != JVMTI_ERROR_NONE)
	handle_global_error (err);

    cls = (*env)->FindClass (env, "java/lang/Object");
    (*jvmti)->GetObjectsWithTags (jvmti, so.next_pos, so.tags, &count, &objects, NULL);
    oa = (*env)->NewObjectArray (env, count, cls, NULL);
    for (i = 0; i < count; i++) 
	(*env)->SetObjectArrayElement (env, oa, i, objects[i]);
    cleanup_tag_list (&so);
    cleanup_tag_list (&tijmp_classes);
    
    cls = (*env)->FindClass (env, "tijmp/TIJMPController");    
    m = (*env)->GetStaticMethodID (env, cls, "childObjects", 
				   "([Ljava/lang/Object;)V");
    if (m != NULL)
	(*env)->CallStaticVoidMethod (env, cls, m, oa);
}
