
/******************************************************************************
* MODULE     : make_widget.gen.h
* DESCRIPTION: Abstract dynamic make_widgets
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <widget.gen.h>

#module make_widget
#import widget

/******************************************************************************
* Abstract widget creation functions
******************************************************************************/

class make_widget_rep: public abstract_struct {
public:
  inline make_widget_rep () {}
  inline virtual ~make_widget_rep () {}
  inline virtual ostream& print (ostream& out);
  virtual widget get_widget (display dis) = 0;
};

class make_widget {
public:
#import abstract_null (make_widget, make_widget_rep)
  inline widget operator () (display dis);
  inline friend ostream& operator << (ostream& out, make_widget cmd);
};
#import code_abstract_null (make_widget, make_widget_rep)

inline ostream& make_widget_rep::print (ostream& out) {
  return out << "make_widget"; }
inline widget make_widget::operator () (display dis) {
  return rep->get_widget (dis); }
inline ostream& operator << (ostream& out, make_widget cmd) {
  if (nil(cmd)) return out << "(null)"; else return cmd->print(out); }

/******************************************************************************
* Exported routines
******************************************************************************/

widget pulldown_button (widget w, make_widget mw);
widget pullright_button (widget w, make_widget mw);

#endmodule // make_widget
