
/******************************************************************************
* MODULE     : edit_math.gen.h
* DESCRIPTION: Editing mathematics
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <editor.gen.h>

#module edit_math
#import editor

class edit_math_rep: virtual public editor_rep {
public:
  edit_math_rep ();
  ~edit_math_rep ();

  void make_group ();
  void make_large_left (string s);
  void make_large_middle (string s);
  void make_large_right (string s);
  void make_big_operator (string s);
  void make_lprime (string s);
  void make_rprime (string s);
  void make_below ();
  void make_above ();
  void make_script (bool sup, bool right);
  void make_fraction ();
  void make_sqrt ();
  void make_var_sqrt ();
  void make_wide (string wide);
  void make_wide_under (string wide);
  void make_neg ();
  void make_tree ();
  void back_prime (tree t, path p);
  void back_in_math (tree t, path p);
  void back_in_math_accent (tree t, path p);

  bool inside_tree ();
  path get_tree (int& i);
  void branch_insert (bool at_right);
  void branch_delete ();
  void back_in_tree (tree t, path p);
};

#endmodule // edit_math
