/************************************************************************/
/*									*/
/*  Paragraph tool:							*/
/*									*/
/************************************************************************/

#   ifndef	TED_PARA_TOOL_H
#   define	TED_PARA_TOOL_H

#   include	"tedBorderTool.h"
#   include	"tedShadingTool.h"
#   include	"tedHeightTool.h"

/************************************************************************/
/*									*/
/*  Resources for the 'Paragraph' page.					*/
/*									*/
/************************************************************************/

typedef struct ParagraphPageResources
    {
    char *		pprParaFirstIndent;
    char *		pprParaLeftIndent;
    char *		pprParaRightIndent;

    char *		pprParaSpaceAbove;
    char *		pprParaSpaceBelow;

    char *		pprOnNewPage;
    char *		pprOnOnePage;

    char *		pprWidctrl;
    char *		pprKeepWithNext;

    char *		pprParaLineDistFree;
    char *		pprParaLineDistAtLeast;
    char *		pprParaLineDistExactly;

    char *		pprShadingPattern;

    char *		pprTopBorder;
    char *		pprBottomBorder;

    char *		pprParaAlignment;
    char *		pprParaAlignMenuTexts[DOCia_COUNT];
    } ParagraphPageResources;

/************************************************************************/
/*									*/
/*  A paragraph tool, i.e. the 'Paragraph' page of the format tool.	*/
/*									*/
/************************************************************************/

typedef struct ParagraphTool
    {
    EditApplication *			ptApplication;
    AppInspector *			ptInspector;
    const ParagraphPageResources *	ptPageResources;

    ParagraphProperties			ptPropertiesSet;
    ParagraphProperties			ptPropertiesChosen;

    APP_WIDGET				ptFirstIndentText;
    APP_WIDGET				ptRightIndentText;
    APP_WIDGET				ptLeftIndentText;

    APP_WIDGET				ptOnNewPageToggle;
    APP_WIDGET				ptOnOnePageToggle;

    APP_WIDGET				ptWidctrlToggle;
    APP_WIDGET				ptKeepWithNextToggle;

    APP_WIDGET				ptSpaceAboveToggle;
    APP_WIDGET				ptSpaceAboveText;

    APP_WIDGET				ptSpaceBelowToggle;
    APP_WIDGET				ptSpaceBelowText;

    BorderTool				ptTopBorderTool;
    BorderTool				ptBottomBorderTool;

    HeightChooser			ptLineDistChooser;

    AppOptionmenu			ptAlignOptionmenu;
    APP_WIDGET				ptAlignItems[DOCia_COUNT];

#   if 0
    ShadingTool				ptShadingTool;
#   endif
    } ParagraphTool;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

void tedFormatToolGetParaResourceTable(	EditApplication *		ea,
					ParagraphPageResources *	ppr,
					InspectorSubjectResources *	isr );

extern void tedFormatFillParagraphChoosers( ParagraphTool *		pt,
					const ParagraphPageResources *	ppr );

extern void tedFormatFillParagraphPage(	ParagraphTool *			pt,
					const ParagraphPageResources *	ppr,
					InspectorSubject *		is,
					APP_WIDGET			pgW,
					const InspectorSubjectResources * isr );

extern void tedFormatToolRefreshParagraphTool(
				ParagraphTool *			pt,
				int *				pEnabled,
				InspectorSubject *		is,
				const DocumentSelection *	bs );

#   endif	/*  TED_PARA_TOOL_H */
