/*
 * Decompiled with CFR 0.152.
 */
package clustering;

import clustering.RawDataInterface;

public class DistanceMatrix {
    protected int dimension = 0;
    protected double[][] distances = null;

    public DistanceMatrix(int n) {
        this.dimension = n;
        this.distances = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                this.distances[i][j] = 1.0;
            }
        }
    }

    public DistanceMatrix(DistanceMatrix distanceMatrix) {
        this.dimension = distanceMatrix.dimension;
        this.distances = new double[this.dimension][this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                this.distances[i][j] = distanceMatrix.distances[i][j];
            }
        }
    }

    public int getDimension() {
        return this.dimension;
    }

    public double elementAt(int n, int n2) {
        return this.distances[n][n2];
    }

    public void solveManhattanDistances(RawDataInterface rawDataInterface) {
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < i; ++j) {
                this.distances[i][j] = rawDataInterface.getManhattanDistance(i, j);
            }
        }
    }

    public void solveCartesianDistances(RawDataInterface rawDataInterface) {
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < i; ++j) {
                this.distances[i][j] = rawDataInterface.getCartesianDistance(i, j);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                stringBuffer.append(this.distances[i][j] + " ");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public void mergeDistances(int n, int n2) {
        int n3;
        int n4;
        for (n4 = 0; n4 < n; ++n4) {
            n3 = this.dimension - (n4 + 1);
            this.distances[n][n4] = (this.distances[n][n4] * this.distances[n][n3] + this.distances[n2][n4] * this.distances[n2][n3]) / (this.distances[n][n3] + this.distances[n2][n3]);
            this.distances[n][n3] = this.distances[n][n3] + this.distances[n2][n3];
        }
        for (n4 = n2 + 1; n4 < this.dimension; ++n4) {
            n3 = this.dimension - (n4 + 1);
            this.distances[n4][n] = (this.distances[n4][n] * this.distances[n3][n] + this.distances[n4][n2] * this.distances[n3][n2]) / (this.distances[n3][n] + this.distances[n3][n2]);
            this.distances[n3][n] = this.distances[n3][n] + this.distances[n3][n2];
        }
    }
}

