/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.CubeDataSource;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.DynaprofDataSource;
import edu.uoregon.tau.perfdmf.FileList;
import edu.uoregon.tau.perfdmf.GprofDataSource;
import edu.uoregon.tau.perfdmf.GyroDataSource;
import edu.uoregon.tau.perfdmf.HPCToolkitDataSource;
import edu.uoregon.tau.perfdmf.HPMToolkitDataSource;
import edu.uoregon.tau.perfdmf.MpiPDataSource;
import edu.uoregon.tau.perfdmf.PSRunDataSource;
import edu.uoregon.tau.perfdmf.PackedProfileDataSource;
import edu.uoregon.tau.perfdmf.TauDataSource;
import edu.uoregon.tau.perfdmf.TauPprofDataSource;
import edu.uoregon.tau.perfdmf.TimeSeriesDataSource;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class UtilFncs {
    public static String lpad(String string, int n) {
        int n2 = n - string.length();
        if (n2 <= 0) {
            return string;
        }
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = 32;
        }
        String string2 = new String(cArray, 0, n2);
        return string2.concat(string);
    }

    public static String pad(String string, int n) {
        int n2 = n - string.length();
        if (n2 <= 0) {
            return string;
        }
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = 32;
        }
        return string.concat(new String(cArray, 0, n2));
    }

    public static String formatDouble(double d, int n, boolean bl) {
        boolean bl2 = false;
        String string = Double.toString(d);
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != 'E') continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            int n2;
            String string2 = "";
            for (n2 = 0; n2 < string.length(); ++n2) {
                string2 = string.charAt(n2) != '.' ? string2 + "#" : string2 + ".";
            }
            n2 = n;
            if (string2.length() < n2) {
                n2 = string2.length();
            }
            if (string2.indexOf(46) + 4 < n2) {
                n2 = string2.indexOf(46) + 4;
            }
            if ((string2 = string2.substring(0, n2)).charAt(string2.length() - 1) == '.') {
                string2 = string2.substring(0, string2.length() - 2);
            }
            DecimalFormat decimalFormat = new DecimalFormat(string2);
            string = decimalFormat.format(d);
            if (bl) {
                return UtilFncs.lpad(string, n);
            }
            return string;
        }
        String string3 = d < 0.1 ? "0.0" : "0.0###";
        string3 = string3 + "E0";
        DecimalFormat decimalFormat = new DecimalFormat(string3);
        string = decimalFormat.format(d);
        if (bl) {
            return UtilFncs.lpad(string, n);
        }
        return string;
    }

    public static String getOutputString(int n, double d, int n2) {
        switch (n) {
            case 0: {
                return UtilFncs.formatDouble(d, n2, true);
            }
            case 1: {
                return UtilFncs.formatDouble(d / 1000.0, n2, true);
            }
            case 2: {
                return UtilFncs.formatDouble(d / 1000000.0, n2, true);
            }
            case 3: {
                int n3 = 0;
                int n4 = 0;
                n3 = (int)(d / 3.6E9);
                n4 = (int)((d -= (double)n3 * 3.6E9) / 6.0E7);
                String string = Integer.toString(n3);
                String string2 = n4 < 10 ? "0" + Integer.toString(n4) : Integer.toString(n4);
                String string3 = n3 >= 1 || n4 >= 1 ? UtilFncs.formatDouble(d / 1000000.0, 1, false) : UtilFncs.formatDouble((d -= (double)n4 * 6.0E7) / 1000000.0, 3, false);
                if (string3.indexOf(69) != -1) {
                    string3 = "00";
                }
                if (string3.length() == 1) {
                    string3 = "0" + string3;
                }
                int n5 = 0;
                for (int i = 0; i < string3.length(); ++i) {
                    if (string3.charAt(i) == ' ') continue;
                    n5 = i;
                    break;
                }
                string3 = string3.substring(n5);
                return UtilFncs.lpad(string + ":" + string2 + ":" + string3, n2);
            }
        }
        throw new RuntimeException("Unexpected string type: " + n);
    }

    public static String getUnitsString(int n, boolean bl, boolean bl2) {
        if (bl2) {
            if (!bl) {
                return "counts";
            }
            switch (n) {
                case 0: {
                    return "Derived metric shown in microseconds format";
                }
                case 1: {
                    return "Derived metric shown in milliseconds format";
                }
                case 2: {
                    return "Derived metric shown in seconds format";
                }
                case 3: {
                    return "Derived metric shown in hour:minute:seconds format";
                }
            }
            throw new RuntimeException("Unexpected string type: " + n);
        }
        if (!bl) {
            return "counts";
        }
        switch (n) {
            case 0: {
                return "microseconds";
            }
            case 1: {
                return "milliseconds";
            }
            case 2: {
                return "seconds";
            }
            case 3: {
                return "hour:minute:seconds";
            }
        }
        throw new RuntimeException("Unexpected string type: " + n);
    }

    public static int exists(Vector vector, int n) {
        if (vector == null) {
            return -1;
        }
        Integer n2 = null;
        int n3 = vector.size();
        for (int i = 0; i < n3; ++i) {
            n2 = (Integer)vector.elementAt(i);
            if (n2 != n) continue;
            return i;
        }
        return -1;
    }

    public static String getRightSide(String string) {
        int n = string.indexOf("=>");
        if (n >= 0) {
            return string.substring(n + 2).trim();
        }
        return string;
    }

    public static String getRightMost(String string) {
        int n = string.lastIndexOf("=>");
        if (n >= 0) {
            return string.substring(n + 2).trim();
        }
        return string;
    }

    public static String getAllButRightMost(String string) {
        int n = string.lastIndexOf("=>");
        if (n >= 0) {
            return string.substring(0, n).trim();
        }
        return string;
    }

    public static String getLeftSide(String string) {
        int n = string.indexOf("=>");
        if (n >= 0) {
            return string.substring(0, n).trim();
        }
        return string;
    }

    public static String getRevLeftSide(String string) {
        int n = string.indexOf("<=");
        if (n >= 0) {
            return string.substring(0, n).trim();
        }
        return string;
    }

    public static DataSource initializeDataSource(File[] fileArray, int n, boolean bl) throws DataSourceException {
        DataSource dataSource = null;
        List<File[]> list = new ArrayList<File[]>();
        switch (n) {
            case 0: {
                FileList fileList = new FileList();
                if (fileArray.length < 1) {
                    list = fileList.helperFindProfiles(System.getProperty("user.dir"));
                    if (list.size() == 0) {
                        throw new DataSourceException("profiles type: no profiles specified");
                    }
                } else if (fileArray[0].isDirectory()) {
                    if (fileArray.length > 1) {
                        throw new DataSourceException("profiles type: you can only specify one directory");
                    }
                    list = fileList.helperFindProfiles(fileArray[0].toString());
                    if (list.size() == 0) {
                        throw new DataSourceException("No profiles found in directory: " + fileArray[0]);
                    }
                } else {
                    list.add(fileArray);
                }
                dataSource = new TauDataSource(list);
                break;
            }
            case 1: {
                if (fileArray.length != 1) {
                    throw new DataSourceException("pprof type: you must specify exactly one file");
                }
                if (fileArray[0].isDirectory()) {
                    throw new DataSourceException("pprof type: you must specify a file, not a directory");
                }
                list.add(fileArray);
                dataSource = new TauPprofDataSource(list);
                break;
            }
            case 2: {
                dataSource = new DynaprofDataSource(fileArray);
                break;
            }
            case 3: {
                if (fileArray.length != 1) {
                    throw new DataSourceException("MpiP type: you must specify exactly one file");
                }
                if (fileArray[0].isDirectory()) {
                    throw new DataSourceException("MpiP type: you must specify a file, not a directory");
                }
                dataSource = new MpiPDataSource(fileArray[0]);
                break;
            }
            case 4: {
                list.add(fileArray);
                dataSource = new HPMToolkitDataSource(list);
                break;
            }
            case 5: {
                dataSource = new GprofDataSource(fileArray, bl);
                break;
            }
            case 6: {
                list.add(fileArray);
                dataSource = new PSRunDataSource(list);
                break;
            }
            case 7: {
                if (fileArray.length != 1) {
                    throw new DataSourceException("Packed Profile type: you must specify exactly one file");
                }
                if (fileArray[0].isDirectory()) {
                    throw new DataSourceException("Packed Profile type: you must specify a file, not a directory");
                }
                dataSource = new PackedProfileDataSource(fileArray[0]);
                break;
            }
            case 8: {
                if (fileArray.length != 1) {
                    throw new DataSourceException("Cube type: you must specify exactly one file");
                }
                if (fileArray[0].isDirectory()) {
                    throw new DataSourceException("Cube type: you must specify a file, not a directory");
                }
                try {
                    Class<?> clazz = Class.forName("org.xml.sax.SAXException");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new DataSourceException("Sorry, cube format requires Java 1.4");
                }
                dataSource = new CubeDataSource(fileArray[0]);
                break;
            }
            case 9: {
                if (fileArray.length != 1) {
                    throw new DataSourceException("HPCToolkit type: you must specify exactly one file");
                }
                if (fileArray[0].isDirectory()) {
                    throw new DataSourceException("HPCToolkit type: you must specify a file, not a directory");
                }
                try {
                    Class<?> clazz = Class.forName("org.xml.sax.SAXException");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new DataSourceException("Sorry, HPCToolkit format requires Java 1.4");
                }
                dataSource = new HPCToolkitDataSource(fileArray[0]);
                break;
            }
            case 10: {
                dataSource = new TimeSeriesDataSource(fileArray[0]);
                break;
            }
            case 100: {
                list.add(fileArray);
                dataSource = new GyroDataSource(list);
                break;
            }
        }
        return dataSource;
    }

    public static class EmptyIterator
    implements ListIterator,
    Iterator {
        public int nextIndex() {
            return 0;
        }

        public int previousIndex() {
            return 0;
        }

        public void remove() {
        }

        public boolean hasNext() {
            return false;
        }

        public boolean hasPrevious() {
            return false;
        }

        public Object next() {
            return null;
        }

        public Object previous() {
            return null;
        }

        public void add(Object object) {
        }

        public void set(Object object) {
        }
    }
}

