/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import javax.swing.JPanel;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLCanvas;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLCapabilitiesChooser;
import net.java.games.jogl.GLContextHelper;
import net.java.games.jogl.GLDrawable;
import net.java.games.jogl.GLDrawableFactory;
import net.java.games.jogl.GLEventListener;
import net.java.games.jogl.GLException;
import net.java.games.jogl.GLPbuffer;
import net.java.games.jogl.GLU;
import net.java.games.jogl.impl.Debug;
import net.java.games.jogl.impl.GLContext;
import net.java.games.jogl.impl.GLContextFactory;
import net.java.games.jogl.impl.GLDrawableHelper;
import net.java.games.jogl.impl.GLPbufferImpl;

public final class GLJPanel
extends JPanel
implements GLDrawable {
    protected static final boolean DEBUG = Debug.debug("GLJPanel");
    private GLDrawableHelper drawableHelper = new GLDrawableHelper();
    private volatile boolean isInitialized;
    private GLCapabilities offscreenCaps;
    private GLCapabilitiesChooser chooser;
    private GLDrawable shareWith;
    private BufferedImage offscreenImage;
    private byte[] readBackBytes;
    private int[] readBackInts;
    private int readBackWidthInPixels;
    private int readBackHeightInPixels;
    private int panelWidth = 0;
    private int panelHeight = 0;
    private Updater updater;
    private int awtFormat;
    private int glFormat;
    private int glType;
    private static boolean hardwareAccelerationDisabled = Debug.isPropertyDefined("jogl.gljpanel.nohw");
    private boolean pbufferInitializationCompleted;
    private GLPbuffer pbuffer;
    private int pbufferWidth = 256;
    private int pbufferHeight = 256;
    private GLCanvas heavyweight;
    private Frame toplevel;
    private GLContext offscreenContext;
    private int[] swapbytes = new int[1];
    private int[] rowlength = new int[1];
    private int[] skiprows = new int[1];
    private int[] skippixels = new int[1];
    private int[] alignment = new int[1];
    private InitAction initAction = new InitAction();
    private DisplayAction displayAction = new DisplayAction();
    private SwapBuffersAction swapBuffersAction = new SwapBuffersAction();
    private PaintImmediatelyAction paintImmediatelyAction = new PaintImmediatelyAction();

    GLJPanel(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GLDrawable gLDrawable) {
        this.offscreenCaps = (GLCapabilities)gLCapabilities.clone();
        this.offscreenCaps.setDoubleBuffered(false);
        this.chooser = gLCapabilitiesChooser;
        this.shareWith = gLDrawable;
    }

    public void display() {
        if (!this.isInitialized) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        } else {
            try {
                EventQueue.invokeAndWait(this.paintImmediatelyAction);
            }
            catch (Exception exception) {
                throw new GLException(exception);
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        if (!this.isInitialized) {
            return;
        }
        this.updater.setGraphics(graphics);
        if (!hardwareAccelerationDisabled) {
            if (!this.pbufferInitializationCompleted) {
                try {
                    this.heavyweight.display();
                    this.pbuffer.display();
                }
                catch (GLException gLException) {
                    if (DEBUG) {
                        gLException.printStackTrace();
                    }
                    this.disableHardwareRendering();
                }
            } else {
                this.pbuffer.display();
            }
        } else {
            this.offscreenContext.invokeGL(this.displayAction, false, this.initAction);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.initialize();
        if (DEBUG) {
            System.err.println("GLJPanel.addNotify()");
        }
    }

    public void removeNotify() {
        if (DEBUG) {
            System.err.println("GLJPanel.removeNotify()");
        }
        if (!hardwareAccelerationDisabled) {
            if (this.pbuffer != null) {
                this.pbuffer.destroy();
            }
            if (this.toplevel != null) {
                this.toplevel.dispose();
            }
            this.pbuffer = null;
            this.heavyweight = null;
            this.toplevel = null;
        } else {
            this.offscreenContext.destroy();
        }
        this.isInitialized = false;
        super.removeNotify();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        if (!this.isInitialized) {
            return;
        }
        int n5 = n;
        int n6 = n2;
        final int n7 = n3;
        final int n8 = n4;
        Runnable runnable = new Runnable(){

            public void run() {
                GLContext gLContext = null;
                GLJPanel.this.readBackWidthInPixels = 0;
                GLJPanel.this.readBackHeightInPixels = 0;
                if (!hardwareAccelerationDisabled) {
                    float f = 2.5f;
                    if (n7 > GLJPanel.this.pbufferWidth || n8 > GLJPanel.this.pbufferHeight || (float)n7 < (float)GLJPanel.this.pbufferWidth / f || (float)n8 < (float)GLJPanel.this.pbufferWidth / f) {
                        if (DEBUG) {
                            System.err.println("Resizing pbuffer from (" + GLJPanel.this.pbufferWidth + ", " + GLJPanel.this.pbufferHeight + ") " + " to fit (" + n7 + ", " + n8 + ")");
                        }
                        if (GLJPanel.this.pbuffer != null) {
                            GLJPanel.this.pbuffer.destroy();
                        }
                        if (GLJPanel.this.toplevel != null) {
                            GLJPanel.this.toplevel.dispose();
                        }
                        GLJPanel.this.isInitialized = false;
                        GLJPanel.this.pbufferWidth = GLJPanel.this.getNextPowerOf2(n7);
                        GLJPanel.this.pbufferHeight = GLJPanel.this.getNextPowerOf2(n8);
                        if (DEBUG) {
                            System.err.println("New pbuffer size is (" + GLJPanel.this.pbufferWidth + ", " + GLJPanel.this.pbufferHeight + ")");
                        }
                        GLJPanel.this.initialize();
                    }
                    GLPbufferImpl gLPbufferImpl = (GLPbufferImpl)GLJPanel.this.pbuffer;
                    gLContext = gLPbufferImpl.getContext();
                    GLJPanel.this.readBackWidthInPixels = GLJPanel.this.pbufferWidth;
                    GLJPanel.this.readBackHeightInPixels = n8;
                } else {
                    GLJPanel.this.offscreenContext.resizeOffscreenContext(n7, n8);
                    gLContext = GLJPanel.this.offscreenContext;
                    GLJPanel.this.readBackWidthInPixels = n7;
                    GLJPanel.this.readBackHeightInPixels = n8;
                }
                if (GLJPanel.this.offscreenImage != null) {
                    GLJPanel.this.offscreenImage.flush();
                    GLJPanel.this.offscreenImage = null;
                }
                GLJPanel.this.panelWidth = n7;
                GLJPanel.this.panelHeight = n8;
                gLContext.invokeGL(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        1.access$1400(this.this$1).getGL().glViewport(0, 0, GLJPanel.access$1200(1.access$1400(this.this$1)), GLJPanel.access$1300(1.access$1400(this.this$1)));
                        GLJPanel.access$1500(1.access$1400(this.this$1)).reshape(1.access$1400(this.this$1), 0, 0, GLJPanel.access$1200(1.access$1400(this.this$1)), GLJPanel.access$1300(1.access$1400(this.this$1)));
                    }
                }, true, GLJPanel.this.initAction);
            }

            static /* synthetic */ GLJPanel access$1400(1 var0) {
                return var0.GLJPanel.this;
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    public void addGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.addGLEventListener(gLEventListener);
    }

    public void removeGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.removeGLEventListener(gLEventListener);
    }

    public GL getGL() {
        if (!hardwareAccelerationDisabled) {
            if (this.pbuffer == null) {
                return null;
            }
            return this.pbuffer.getGL();
        }
        if (this.offscreenContext == null) {
            return null;
        }
        return this.offscreenContext.getGL();
    }

    public void setGL(GL gL) {
        if (!hardwareAccelerationDisabled) {
            if (this.pbuffer != null) {
                this.pbuffer.setGL(gL);
            }
        } else if (this.offscreenContext != null) {
            this.offscreenContext.setGL(gL);
        }
    }

    public GLU getGLU() {
        if (!hardwareAccelerationDisabled) {
            return this.pbuffer.getGLU();
        }
        return this.offscreenContext.getGLU();
    }

    public void setGLU(GLU gLU) {
        if (!hardwareAccelerationDisabled) {
            this.pbuffer.setGLU(gLU);
        } else {
            this.offscreenContext.setGLU(gLU);
        }
    }

    public void setRenderingThread(Thread thread) throws GLException {
    }

    public Thread getRenderingThread() {
        return null;
    }

    public void setNoAutoRedrawMode(boolean bl) {
    }

    public boolean getNoAutoRedrawMode() {
        return false;
    }

    public void setAutoSwapBufferMode(boolean bl) {
        if (!hardwareAccelerationDisabled) {
            this.pbuffer.setAutoSwapBufferMode(bl);
        } else {
            this.offscreenContext.setAutoSwapBufferMode(bl);
        }
    }

    public boolean getAutoSwapBufferMode() {
        if (!hardwareAccelerationDisabled) {
            return this.pbuffer.getAutoSwapBufferMode();
        }
        return this.offscreenContext.getAutoSwapBufferMode();
    }

    public void swapBuffers() {
        if (!hardwareAccelerationDisabled) {
            this.pbuffer.swapBuffers();
        } else {
            this.offscreenContext.invokeGL(this.swapBuffersAction, false, this.initAction);
        }
    }

    public boolean canCreateOffscreenDrawable() {
        return false;
    }

    public GLPbuffer createOffscreenDrawable(GLCapabilities gLCapabilities, int n, int n2) {
        throw new GLException("Not supported");
    }

    GLContext getContext() {
        if (!hardwareAccelerationDisabled) {
            return ((GLPbufferImpl)this.pbuffer).getContext();
        }
        return this.offscreenContext;
    }

    private void disableHardwareRendering() {
        if (Debug.verbose()) {
            System.err.println("GLJPanel: Falling back on software rendering due to pbuffer problems");
        }
        hardwareAccelerationDisabled = true;
        this.pbufferInitializationCompleted = false;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                GLJPanel.this.toplevel.setVisible(false);
            }
        });
        this.initialize();
    }

    private void initialize() {
        if (!hardwareAccelerationDisabled) {
            boolean bl = false;
            if (this.heavyweight == null) {
                this.heavyweight = GLDrawableFactory.getFactory().createGLCanvas(new GLCapabilities(), this.shareWith);
                bl = true;
            }
            if (this.heavyweight.canCreateOffscreenDrawable()) {
                if (bl) {
                    this.toplevel = new Frame();
                    this.toplevel.setUndecorated(true);
                }
                this.pbuffer = this.heavyweight.createOffscreenDrawable(this.offscreenCaps, this.pbufferWidth, this.pbufferHeight);
                this.updater = new Updater();
                this.pbuffer.addGLEventListener(this.updater);
                this.pbufferInitializationCompleted = false;
                if (bl) {
                    this.toplevel.add(this.heavyweight);
                    this.toplevel.setSize(1, 1);
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            GLJPanel.this.toplevel.setVisible(true);
                        }
                        catch (GLException gLException) {
                            if (DEBUG) {
                                gLException.printStackTrace();
                            }
                            GLJPanel.this.disableHardwareRendering();
                        }
                    }
                });
                this.isInitialized = true;
                return;
            }
            hardwareAccelerationDisabled = true;
        }
        this.offscreenContext = GLContextFactory.getFactory().createGLContext(null, this.offscreenCaps, this.chooser, GLContextHelper.getContext(this.shareWith));
        this.offscreenContext.resizeOffscreenContext(this.panelWidth, this.panelHeight);
        this.updater = new Updater();
        if (this.panelWidth > 0 && this.panelHeight > 0) {
            this.offscreenContext.invokeGL(new Runnable(){

                public void run() {
                    GLJPanel.this.getGL().glViewport(0, 0, GLJPanel.this.panelWidth, GLJPanel.this.panelHeight);
                    GLJPanel.this.drawableHelper.reshape(GLJPanel.this, 0, 0, GLJPanel.this.panelWidth, GLJPanel.this.panelHeight);
                }
            }, true, this.initAction);
        }
        this.isInitialized = true;
    }

    private int getNextPowerOf2(int n) {
        if ((n - 1 & n) == 0) {
            return n;
        }
        int n2 = 0;
        while (n > 0) {
            n >>= 1;
            ++n2;
        }
        return 1 << n2;
    }

    static /* synthetic */ byte[] access$2202(GLJPanel gLJPanel, byte[] byArray) {
        gLJPanel.readBackBytes = byArray;
        return byArray;
    }

    static /* synthetic */ int[] access$2302(GLJPanel gLJPanel, int[] nArray) {
        gLJPanel.readBackInts = nArray;
        return nArray;
    }

    class PaintImmediatelyAction
    implements Runnable {
        PaintImmediatelyAction() {
        }

        public void run() {
            GLJPanel.this.paintImmediately(0, 0, GLJPanel.this.getWidth(), GLJPanel.this.getHeight());
        }
    }

    class SwapBuffersAction
    implements Runnable {
        SwapBuffersAction() {
        }

        public void run() {
            GLJPanel.this.offscreenContext.swapBuffers();
        }
    }

    class DisplayAction
    implements Runnable {
        DisplayAction() {
        }

        public void run() {
            GLJPanel.this.updater.display(GLJPanel.this);
        }
    }

    class InitAction
    implements Runnable {
        InitAction() {
        }

        public void run() {
            GLJPanel.this.updater.init(GLJPanel.this);
        }
    }

    class Updater
    implements GLEventListener {
        private Graphics g;

        Updater() {
        }

        public void setGraphics(Graphics graphics) {
            this.g = graphics;
        }

        public void init(GLDrawable gLDrawable) {
            if (!hardwareAccelerationDisabled) {
                if (DEBUG) {
                    System.err.println("GLJPanel$Updater.init(): pbufferInitializationCompleted = true");
                }
                GLJPanel.this.pbufferInitializationCompleted = true;
                EventQueue.invokeLater(new Runnable(this){
                    private final /* synthetic */ Updater this$1;
                    {
                        this.this$1 = updater;
                    }

                    public void run() {
                        if (GLJPanel.access$600(Updater.access$1900(this.this$1)) != null) {
                            GLJPanel.access$600(Updater.access$1900(this.this$1)).setVisible(false);
                        }
                    }
                });
            }
            GLJPanel.this.drawableHelper.init(GLJPanel.this);
        }

        public void display(GLDrawable gLDrawable) {
            GLJPanel.this.drawableHelper.display(GLJPanel.this);
            if (GLJPanel.this.offscreenImage == null && GLJPanel.this.panelWidth > 0 && GLJPanel.this.panelHeight > 0) {
                int n = 0;
                int n2 = 0;
                if (!hardwareAccelerationDisabled) {
                    n = 1;
                    n2 = 33639;
                } else {
                    n = GLJPanel.this.offscreenContext.getOffscreenContextBufferedImageType();
                }
                GLJPanel.this.offscreenImage = new BufferedImage(GLJPanel.this.panelWidth, GLJPanel.this.panelHeight, n);
                switch (n) {
                    case 5: {
                        GLJPanel.this.glFormat = 32992;
                        GLJPanel.this.glType = 5121;
                        GLJPanel.access$2202(GLJPanel.this, new byte[GLJPanel.this.readBackWidthInPixels * GLJPanel.this.readBackHeightInPixels * 3]);
                        break;
                    }
                    case 1: 
                    case 2: {
                        GLJPanel.this.glFormat = 32993;
                        GLJPanel.this.glType = hardwareAccelerationDisabled ? GLJPanel.this.offscreenContext.getOffscreenContextPixelDataType() : n2;
                        GLJPanel.access$2302(GLJPanel.this, new int[GLJPanel.this.readBackWidthInPixels * GLJPanel.this.readBackHeightInPixels]);
                        break;
                    }
                    default: {
                        throw new GLException("Unsupported offscreen image type " + n);
                    }
                }
            }
            if (GLJPanel.this.offscreenImage != null) {
                GL gL = GLJPanel.this.getGL();
                gL.glGetIntegerv(3328, GLJPanel.this.swapbytes);
                gL.glGetIntegerv(3330, GLJPanel.this.rowlength);
                gL.glGetIntegerv(3331, GLJPanel.this.skiprows);
                gL.glGetIntegerv(3332, GLJPanel.this.skippixels);
                gL.glGetIntegerv(3333, GLJPanel.this.alignment);
                gL.glPixelStorei(3328, 0);
                gL.glPixelStorei(3330, GLJPanel.this.readBackWidthInPixels);
                gL.glPixelStorei(3331, 0);
                gL.glPixelStorei(3332, 0);
                gL.glPixelStorei(3333, 1);
                gL.glReadBuffer(1028);
                if (GLJPanel.this.readBackBytes != null) {
                    gL.glReadPixels(0, 0, GLJPanel.this.readBackWidthInPixels, GLJPanel.this.readBackHeightInPixels, GLJPanel.this.glFormat, GLJPanel.this.glType, GLJPanel.this.readBackBytes);
                } else if (GLJPanel.this.readBackInts != null) {
                    gL.glReadPixels(0, 0, GLJPanel.this.readBackWidthInPixels, GLJPanel.this.readBackHeightInPixels, GLJPanel.this.glFormat, GLJPanel.this.glType, GLJPanel.this.readBackInts);
                }
                gL.glPixelStorei(3328, GLJPanel.this.swapbytes[0]);
                gL.glPixelStorei(3330, GLJPanel.this.rowlength[0]);
                gL.glPixelStorei(3331, GLJPanel.this.skiprows[0]);
                gL.glPixelStorei(3332, GLJPanel.this.skippixels[0]);
                gL.glPixelStorei(3333, GLJPanel.this.alignment[0]);
                if (GLJPanel.this.readBackBytes != null || GLJPanel.this.readBackInts != null) {
                    Object[] objectArray = null;
                    Object[] objectArray2 = null;
                    int n = 0;
                    int n3 = 0;
                    if (GLJPanel.this.readBackBytes != null) {
                        objectArray = GLJPanel.this.readBackBytes;
                        objectArray2 = ((DataBufferByte)GLJPanel.this.offscreenImage.getRaster().getDataBuffer()).getData();
                        n = GLJPanel.this.readBackWidthInPixels * 3;
                        n3 = GLJPanel.this.offscreenImage.getWidth() * 3;
                    } else {
                        objectArray = GLJPanel.this.readBackInts;
                        objectArray2 = ((DataBufferInt)GLJPanel.this.offscreenImage.getRaster().getDataBuffer()).getData();
                        n = GLJPanel.this.readBackWidthInPixels;
                        n3 = GLJPanel.this.offscreenImage.getWidth();
                    }
                    if (!hardwareAccelerationDisabled || GLJPanel.this.offscreenContext.offscreenImageNeedsVerticalFlip()) {
                        int n4 = 0;
                        for (int i = (GLJPanel.this.offscreenImage.getHeight() - 1) * n3; i >= 0; i -= n3) {
                            System.arraycopy(objectArray, n4, objectArray2, i, n3);
                            n4 += n;
                        }
                    } else {
                        int n5 = 0;
                        int n6 = n3 * GLJPanel.this.offscreenImage.getHeight();
                        for (int i = 0; i < n6; i += n3) {
                            System.arraycopy(objectArray, n5, objectArray2, i, n3);
                            n5 += n;
                        }
                    }
                    this.g.drawImage(GLJPanel.this.offscreenImage, 0, 0, GLJPanel.this.offscreenImage.getWidth(), GLJPanel.this.offscreenImage.getHeight(), GLJPanel.this);
                }
            }
        }

        public void reshape(GLDrawable gLDrawable, int n, int n2, int n3, int n4) {
        }

        public void displayChanged(GLDrawable gLDrawable, boolean bl, boolean bl2) {
        }

        static /* synthetic */ GLJPanel access$1900(Updater updater) {
            return updater.GLJPanel.this;
        }
    }
}

